//
//  AlertItem.swift
//  CTFit
//
//  Created by Mac on 2020/5/27.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

typealias AlertHandler = (UIAlertAction) -> Void

typealias InputHandler = (UITextField) -> Void

class AlertItem {
    
    
    var text: String
    
    var textColor: UIColor?
    
    var style: UIAlertAction.Style
    
    var handler: AlertHandler
    
    init(with text: String, color: UIColor? = nil, style: UIAlertAction.Style, handler: @escaping AlertHandler) {
        self.text = text
        self.textColor = color
        self.style = style
        self.handler = handler
    }
    
}


extension AlertItem {
    
    static func no(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.Base.no.locastr, style: .cancel, handler: handler)
    }
    
    static func yes(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.Base.yes.locastr, style: .default, handler: handler)
    }
    
    static func cancel(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.Base.cancel.locastr, style: .cancel, handler: handler)
    }
    
    static func ok(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.Base.ok.locastr, style: .default, handler: handler)
    }
    
    private static func destructive(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: "Destructive", style: .destructive, handler: handler)
    }
    
    static func album(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.ImagePicker.album.locastr, style: .default, handler: handler)
    }
    
    static func takePicture(with handler: @escaping AlertHandler) -> AlertItem {
        AlertItem(with: SRString.Connected.take_picture.locastr, style: .default, handler: handler)
    }
}

