//
//  AlertController.swift
//  CTFit
//
//  Created by Mac on 2020/5/27.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class AlertManager: NSObject, UITextFieldDelegate {
    
    @discardableResult
    private static func show(title: String?, message: String?, items:[AlertItem]?) -> UIAlertController {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
        items?.forEach({ (item) in
            let action = UIAlertAction(title: item.text, style: item.style, handler: item.handler)
            alert.addAction(action)
        })
        Helper.currentVc?.present(alert, animated: true, completion: nil)
        return alert
    }
    
    @discardableResult
    private static func show(title: String?, message: String?, items:[AlertItem]?, inputHander: @escaping InputHandler) -> UIAlertController {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .alert)
        alert.addTextField { (field) in inputHander(field) }
        items?.forEach({ (item) in
            let action = UIAlertAction(title: item.text, style: item.style, handler: item.handler)
            alert.addAction(action)
        })
        Helper.currentVc?.present(alert, animated: true, completion: nil)
        return alert
    }
    
    @discardableResult
    private static func sheet(title: String?, message: String?, items:[AlertItem]?) -> UIAlertController {
        let alert = UIAlertController(title: title, message: message, preferredStyle: .actionSheet)
        items?.forEach({ (item) in
            let action = UIAlertAction(title: item.text, style: item.style, handler: item.handler)
            alert.addAction(action)
        })
        Helper.currentVc?.present(alert, animated: true, completion: nil)
        return alert
    }
    
    /// 确定、取消
    @discardableResult
    static func show(title: String?, message: String?,
                     okHander: @escaping AlertHandler,
                     cancelHander: @escaping AlertHandler) -> UIAlertController {
        let okItem = AlertItem.ok(with: okHander)
        let cancelItem = AlertItem.cancel(with: cancelHander)
        return show(title: title, message: message, items: [cancelItem, okItem])
    }
    
    /// 确定
    @discardableResult
    static func show(title: String?, message: String?,
                     okHander: @escaping AlertHandler) -> UIAlertController {
        let okItem = AlertItem.ok(with: okHander)
        return show(title: title, message: message, items: [okItem])
    }
    
    /// 是、否
    @discardableResult
    static func show(title: String?, message: String?,
                     yesHander: @escaping AlertHandler,
                     noHander: @escaping AlertHandler) -> UIAlertController {
        let yesItem = AlertItem.yes(with: yesHander)
        let noItem = AlertItem.no(with: noHander)
        return show(title: title, message: message, items: [noItem, yesItem])
    }
    
    /// 重试、取消
    @discardableResult
    static func show(title: String?, message: String?,
                     retryHander: @escaping AlertHandler,
                     cancelHander: @escaping AlertHandler) -> UIAlertController {
        let retryItem = AlertItem.ok(with: retryHander)
        let cancelItem = AlertItem.cancel(with: cancelHander)
        return show(title: title, message: message, items: [cancelItem, retryItem])
    }
    
    
    /// 输入框
    @discardableResult
    static func show(title: String?, message: String?,
                     inputHander: @escaping InputHandler,
                     okHander: @escaping AlertHandler,
                     cancelHander: @escaping AlertHandler) -> UIAlertController {

        let okItem = AlertItem.ok(with: okHander)
        let cancelItem = AlertItem.cancel(with: cancelHander)
        return show(title: title, message: message, items: [cancelItem, okItem]) { (textField) in
            textField.returnKeyType = .done
            textField.clearButtonMode = .always
            inputHander(textField)
        }
    }
    
    /// 是、否
    @discardableResult
    static func sheet(title: String?, message: String?,
                      yesHander: @escaping AlertHandler,
                      noHander: @escaping AlertHandler) -> UIAlertController {
        let yesItem = AlertItem.yes(with: yesHander)
        let noItem = AlertItem.no(with: noHander)
        return sheet(title: title, message: message, items: [noItem, yesItem])
    }
    
    /// 图片选择
    @discardableResult
    static func sheet(title: String?, message: String?,
                      takePictureHander: @escaping AlertHandler,
                      albumHander: @escaping AlertHandler,
                      cancelHander: @escaping AlertHandler) -> UIAlertController {
        let takePictureItem = AlertItem.takePicture(with: takePictureHander)
        let albumItem = AlertItem.album(with: albumHander)
        let cancelItem = AlertItem.cancel(with: cancelHander)
        return sheet(title: title, message: message, items: [takePictureItem, albumItem, cancelItem])
    }
}

