//
//  AppDelegate.swift
//  ctband
//
//  Created by Mac on 2020/4/15.
//  Copyright © 2020 shirajo. All rights reserved.
//

/// com.jpaxh.CTFit
/// com.shirajo.ctfit

/// Xcode 上传App时，卡在Authenticating with the App Store
/// 1、Finder前往文件夹（快捷键：Cmd+Shift+g） ~/Library/Caches/com.apple.amp.itmstransporter/
/// 2、删除文件夹内的所有文件
/// 3、AppStore下载Transporter
/// 4、添加ipa至Transporter, 点验证、验证、验证。验证的过程就会下载刚才删除的所有文件，都下载完了，就验证通过了。此时就可以上传了。

import UIKit
import IQKeyboardManagerSwift
import PerformanceMonitor

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?
    
    var application: UIApplication = .shared
    
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        
        // TDAppFluencyMonitor.shared().startMonitoring()
        TDRunloopMonitor.shared().startMonitoring()
        TDResourceMonitor().startMonitoring()
        TDFPSMonitor.shared().startMonitoring()
        

        UncaughtExceptionHandle.standard()
        self.application = application
        window = UIWindow(frame: UIScreen.main.bounds)
        window?.backgroundColor = Colors.Base.background
        prepareRootScene()
        
        return true
    }
    
    func applicationDidReceiveMemoryWarning(_ application: UIApplication) {
        
    }
    
    private func prepareRootScene(){
        var rootVc: UIViewController
        if SupportUtils.privacyEnable, !PrivacyView.agreed { rootVc = privacyVc() }
        else { rootVc = homeVc() }
        window?.rootViewController = rootVc
        window?.makeKeyAndVisible()
    }
    
    private func privacyVc() -> UIViewController {
        return BaseNavigationController(rootViewController: PrivacyViewController())
    }
    
    private func homeVc(_ first: Bool = true) -> UIViewController {
        if first { configuration() }
        if ApplicationDatasource.tabbarStyle { return HomeTabBarController() }
        return BaseNavigationController(rootViewController: HomeCircleContrller())
    }
    
    private func configuration() {
        UILog.i("Background modes: \(AppUtils.backgroundModes)")
        PushNotifyManager.registerNotifications(application)
        JZLocationConverter.start(finished: nil)
        IQKeyboardManager.shared.enable = true
        MigrationHelper.setup()
        AppUtils.saveInfo()
        quickActions()
        
        _ = BandData.shared
        SportViewController.observe()
        BandSettings.bandObserve()
        LocationHelper.observeWeatherForBand()
        AudioManager.observeFindPhone()
        AutoConnectManager.autoConnect()
    }
    
    func enterToHomeController(first: Bool = true) {
        let transition = CATransition()
        transition.duration = 0.35
        window?.rootViewController = homeVc(first)
        window?.makeKeyAndVisible()
        window?.layer.add(transition, forKey: nil)
    }
}

