//
//  BDClockInfo.swift
//  CTFit
//
//  Created by Mac on 2021/11/3.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation


class BDClockInfo: BDModelProtocol {
    ///: - Initialize
    required init() { }
    /// 闹钟项 最多四组
    var clockArray: [BDClockItem] = [BDClockItem]()
    /// 日程项 最多四组 (series_s 无日程)
    var scheduleArray: [BDScheduleItem] =  [BDScheduleItem]()
    
    static var band: BDClockInfo {
        if BandConnect.protocolType == .series_z { return parse_z() }
        if BandConnect.protocolType == .series_s { return parse_s() }
        return BDClockInfo()
    }
}

extension BDClockInfo: Equatable {
    static func == (lhs: BDClockInfo, rhs: BDClockInfo) -> Bool {
        guard lhs.clockArray == rhs.clockArray,
              lhs.scheduleArray == rhs.scheduleArray else { return false }
        return true
    }
}


import BandKit
extension BDClockInfo {
    var band_z: SRAlarmClock {
        let m = SRAlarmClock()
        m.clockArray = clockArray.map({ $0.band_z })
        m.scheduleArray = scheduleArray.map({ $0.band_z })
        return m
    }
    private static func parse(_ t: SRAlarmClock) -> BDClockInfo {
        let m = BDClockInfo()
        m.clockArray = t.clockArray.map({ BDClockItem.parse($0) })
        m.scheduleArray = t.scheduleArray.map({ BDScheduleItem.parse($0) })
        return m
    }
    private static func parse_z() -> BDClockInfo { parse(SRDataManager.clockInfo) }
}

import YFitKit
extension BDClockInfo {
    var band_s: YFClockInfo {
        let m = YFClockInfo()
        m.alarm_infos = clockArray.map({ $0.band_s })
        return m
    }
    private static func parse(_ t: YFClockInfo) -> BDClockInfo {
        let m = BDClockInfo()
        m.clockArray = t.alarm_infos.map({ BDClockItem.parse($0) })
        return m
    }
    private static func parse_s() -> BDClockInfo { parse(YFDataManager.hybridInfo.alarmInfo) }

}


