//
//  BDScheduleItem.swift
//  CTFit
//
//  Created by Mac on 2021/11/3.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation

class BDScheduleItem: BDModelProtocol {
    
    ///: - Initialize
    required init() { }
    
    /// 开关: 0 关闭 、1 打开
    var enable: Bool = false
    /// 时间戳，是相对于1970-1-1的时间 单位 秒 (年/月/日 时：分)
    var time: TimeInterval = { Date().timeIntervalSince1970 + 120 }()
    /// 震动
    var vibrate: BDVibrate = BDVibrate()
    /// 闹钟标签：max ( 30 Byte )
    var label: String = ""
    
    var date: Date {
        get {
            Date(timeIntervalSince1970: time)
        }
        set {
            time = newValue.timeIntervalSince1970
        }
    }
    
    var datetime: String { return dformatter.string(from: Date(timeIntervalSince1970: time)) }
    lazy var dformatter: DateFormatter = {
        let dformatter = DateFormatter.gregorian
        dformatter.dateFormat = "yyyy-MM-dd HH:mm"
        return dformatter
    }()
    
}

extension BDScheduleItem: Equatable {
    static func == (lhs: BDScheduleItem, rhs: BDScheduleItem) -> Bool {
        guard lhs.enable == rhs.enable,
              lhs.time == rhs.time, lhs.vibrate == rhs.vibrate, lhs.label == rhs.label else { return false }
        return true
    }
}

import BandKit

extension BDScheduleItem {

    var band_z: SRScheduleItem {
        let m = SRScheduleItem()
        m.feature = (enable ? 1 : 0)
        m.time = time
        m.vibrate = vibrate.band_z
        m.label = label
        return m
    }
    
    static func parse(_ t: SRScheduleItem) -> BDScheduleItem {
        let m = BDScheduleItem()
        m.enable = (t.feature > 0)
        m.time = t.time
        m.vibrate.update(t.vibrate)
        m.label = t.label
        return m
    }
}


