//
//  BandData.swift
//  CTFit
//
//  Created by Mac on 2021/10/11.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation
import RxSwift
import RxCocoa
import Repeater
import RxBluetoothKit
import BandKit
import YFitKit
import NEUtils

class BandData {
    
    init() {
        _ = BandSearch.shared
        _ = BandConnect.shared
        observe()
    }
    
    // MARK: - Field
    private(set) var band: BandPeripheral?
   

    //Rx
    private lazy var disposeBag = DisposeBag()
    private lazy var mainScheduler = MainScheduler.instance

    /// : - Private Subject
    private let updateSubject = PublishSubject<BDDataType>()
    private let appNotifySubject = PublishSubject<BDAppNotifyType>()

    private func observe() {
        NEAppNotifyUtils.observable.subscribe(onNext: { [weak self] type in
            guard let strong = self else { return }
            strong.appNotifySubject.onNext(BDAppNotifyType.parse(type))
        }).disposed(by: disposeBag)
        
        SRDataManager.updatedOutput.observeOn(mainScheduler).subscribe(onNext: { [weak self] type in
            guard let strong = self else { return }
            strong.updateSubject.onNext(BDDataType.parse(type))
        }).disposed(by: disposeBag)
        
        YFDataManager.updateOutput.observeOn(mainScheduler).subscribe(onNext: { [weak self] type in
            guard let strong = self else { return }
            strong.updateSubject.onNext(BDDataType.parse(type))
        }).disposed(by: disposeBag)
    }
}

extension BandData {
    static let shared: BandData = BandData()
    private static var protocolType: BDProtocolType { BandConnect.protocolType }

    ///: - output
    ///更新数据
    public static var updatedOutput: Observable<BDDataType> { shared.updateSubject }
    public static var appNotifyOutput: Observable<BDAppNotifyType> { shared.appNotifySubject }
}

extension BandData {
    
    /// 显示版本
    public static var showVersion: String {
        switch protocolType {
        case .series_z: return SRDataManager.firmwareInfo.showVersion
        case .series_s: return ""
        }
    }
    
    /// 删除个人数据
    public static func deletePersonalData() {
        ToastUtils.showActivity()
        CSVHelper.deleteAll()
        GpxRecord.remove()
        SRDataManager.deletePersonalData()
        YFDataManager.deletePersonalData()
        ToastUtils.hideActivity()
    }
    
    /// 升级检测
    public static func upgradeCheck() {
        switch protocolType {
        case .series_z: ConnectedViewController.upgradeCheckZ()
        case .series_s: break
        }
    }
    
    public static func performWakeUp() {
        switch protocolType {
        case .series_z: SRDataManager.performWakeUp()
        case .series_s: YFDataManager.performWakeUp()
        }
    }
    
    ///: series_z
    public static var firmwareFeature: BDFirmwareFeature { BDFirmwareFeature.parse(SRDataManager.firmwareInfo.feature) }

}






