//
//  BandModelProtocol.swift
//  CTFit
//
//  Created by Mac on 2021/10/29.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation
import HandyJSON

// MARK: - Copyable
public protocol BDCopyable: Codable {
    func copy() -> Self
}
public extension BDCopyable {
    func copy() -> Self {
        let encoder = JSONEncoder()
        guard let data = try? encoder.encode(self) else { fatalError("encode失败") }
        let decoder = JSONDecoder()
        guard let target = try? decoder.decode(Self.self, from: data) else { fatalError("decode失败") }
        return target
    }
}

// MARK: - EnumtProtocol
public protocol BDEnumtProtocol: BDCopyable, HandyJSONEnum {}


// MARK: - ModelProtocol
public protocol BDModelProtocol: BDCopyable, HandyJSON, CustomStringConvertible {}
public extension BDModelProtocol {
    var json: [String: Any] { toJSON() ?? [String: Any]() }
    var jsonString: String { toJSONString() ?? "{ Nil }" }
    var jsonStringPrettyPrint: String { toJSONString(prettyPrint: true) ?? "{ Nil }" }
    var description: String { jsonString }
    var kitString: String { jsonString }

}



