//
//  BandPeripheral.swift
//  CTFit
//
//  Created by Mac on 2021/9/29.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation
import BandKit
import YFitKit

class BandPeripheral {
    
    private init() { protocolType = .series_z }
    required convenience init(searched peripheral: SRPeripheral) {
        self.init()
        self.protocolType = .series_z
        self.peripheral_z = peripheral
    }
    
    required convenience init(searched peripheral: YFPeripheral) {
        self.init()
        self.protocolType = .series_s
        self.peripheral_s = peripheral
    }
    
    // MARK: - Field
    private(set) var protocolType: BDProtocolType
    var peripheral_z: SRPeripheral?
    var peripheral_s: YFPeripheral?
    
    var peripheralName: String {
        if let peripheral = peripheral_z { return peripheral.peripheralName }
        if let peripheral = peripheral_s { return peripheral.peripheralName }
        return "__"
    }
    
    var rssiText: String {
        if let peripheral = peripheral_z { return peripheral.rssiText }
        if let peripheral = peripheral_s { return peripheral.rssiText }
        return "__"
    }

    
    var support: Bool {
        if protocolType == .series_z { return SupportUtils.support(type: .series_z, name: peripheralName) }
        if protocolType == .series_s { return SupportUtils.support(type: .series_s, name: peripheralName) }
        return false
    }
}

extension BandPeripheral: Comparable {
    
    private var rssi: Int {
        if let peripheral = peripheral_z { return peripheral.rssiValue }
        if let peripheral = peripheral_s { return peripheral.rssiValue }
        return -200
    }
    
    private var uuidString: String {
        if let peripheral = peripheral_z { return peripheral.uuid }
        if let peripheral = peripheral_s { return peripheral.uuid }
        return "--"
    }
    
    public static func < (lhs: BandPeripheral, rhs: BandPeripheral) -> Bool {
        return lhs.rssi < rhs.rssi
    }
    
    public static func == (lhs: BandPeripheral, rhs: BandPeripheral) -> Bool {
        return lhs.uuidString == rhs.uuidString
    }
}
