//
//  BandSettings+Extension.swift
//  CTFit
//
//  Created by Mac on 2021/10/20.
//  Copyright © 2021 jpaxh. All rights reserved.
//

import Foundation
import BandKit
import YFitKit

enum BDHandType: Int, BDEnumtProtocol {
    case left, right
    static var collection: [BDHandType] = [.left, .right]
    var text: String {
        switch self {
        case .left: return SRString.Personal.hand_left.locastr
        case .right: return SRString.Personal.hand_right.locastr
        }
    }
    
    var band_s: YFHandType {
        switch self {
        case .left: return .left
        case .right: return .right
        }
    }
    
    static func parse(_ t: YFHandType) -> BDHandType{
        switch t {
        case .left: return .left
        case .right: return .right
        }
    }
}

enum BDGenderType: Int, BDEnumtProtocol {
    case male, female
    static var collection: [BDGenderType] = [.male, .female]
    
    var text: String {
        switch self {
        case .male: return SRString.Personal.male.locastr
        case .female: return SRString.Personal.female.locastr
        }
    }
    
    var band_z: SRGenderType {
        switch self {
        case .male: return .male
        case .female: return .female
        }
    }
    
    static func parse(_ t: SRGenderType) -> BDGenderType{
        switch t {
        case .male: return .male
        case .female: return .female
        }
    }
    
    var band_s: YFGenderType {
        switch self {
        case .male: return .male
        case .female: return .female
        }
    }
    
    static func parse(_ t: YFGenderType) -> BDGenderType{
        switch t {
        case .male: return .male
        case .female: return .female
        }
    }
}

enum BDSystemType: Int, BDEnumtProtocol {
    case metric, imperial
    static var collection: [BDSystemType] = [.metric, .imperial]
   
    var text: String {
        switch self {
        case .metric: return SRString.Device.metric.locastr
        case .imperial: return SRString.Device.imperial.locastr
        }
    }
    
    var weight: String {
        switch self {
        case .metric: return SRString.Unit.kg.locastr
        case .imperial: return SRString.Unit.lb.locastr
        }
    }
    
    var distance: String {
        switch self {
        case .metric: return SRString.Unit.km.locastr
        case .imperial: return SRString.Unit.mile.locastr
        }
    }
    
    var speed: String {
        switch self {
        case .metric: return SRString.Unit.km_ph.locastr
        case .imperial: return SRString.Unit.mile_ph.locastr
        }
    }
     
    var band_z: SRSystemType {
        switch self {
        case .metric: return .metric
        case .imperial: return .imperial
        }
    }
    static func parse(_ t: SRSystemType) -> BDSystemType{
        switch t {
        case .metric: return .metric
        case .imperial: return .imperial
        }
    }
    
    var band_s: YFSystemType {
        switch self {
        case .metric: return .metric
        case .imperial: return .imperial
        }
    }
    static func parse(_ t: YFSystemType) -> BDSystemType{
        switch t {
        case .metric: return .metric
        case .imperial: return .imperial
        }
    }
}


enum BDHourlyType: Int, BDEnumtProtocol {
    case h12, h24
    static var collection: [BDHourlyType] = [.h24, .h12]
    var text: String {
        switch self {
        case .h12: return "12"
        case .h24: return "24"
        }
    }
    
    var band_z: SRHourlyType {
        switch self {
        case .h12: return .h12
        case .h24: return .h24
        }
    }
    static func parse(_ t: SRHourlyType) -> BDHourlyType{
        switch t {
        case .h12: return .h12
        case .h24: return .h24
        }
    }
    
    var band_s: YFHourlyType {
        switch self {
        case .h12: return .h12
        case .h24: return .h24
        }
    }
    static func parse(_ t: YFHourlyType) -> BDHourlyType{
        switch t {
        case .h12: return .h12
        case .h24: return .h24
        }
    }
}

enum BDTempUnitsType: Int, BDEnumtProtocol {
    case centigrade, fahrenheit
    static var collection: [BDTempUnitsType] = [.centigrade, .fahrenheit]
    var text: String {
        switch self {
        case .centigrade: return SRString.Device.centigrade.locastr
        case .fahrenheit: return SRString.Device.fahrenheit.locastr
        }
    }
    var band_z: SRTempUnitsType {
        switch self {
        case .centigrade: return .centigrade
        case .fahrenheit: return .fahrenheit
        }
    }
    static func parse(_ t: SRTempUnitsType) -> BDTempUnitsType{
        switch t {
        case .centigrade: return .centigrade
        case .fahrenheit: return .fahrenheit
        }
    }
}

enum BDDateformatType: Int, BDEnumtProtocol {
    case mmdd, ddmm
    static var collection: [BDDateformatType] = [.mmdd, .ddmm]
    var text: String {
        switch self {
        case .mmdd: return SRString.Device.dateformat_mmdd.locastr
        case .ddmm: return SRString.Device.dateformat_ddmm.locastr
        }
    }
    var band_z: SRDateformatType {
        switch self {
        case .mmdd: return .mmdd
        case .ddmm: return .ddmm
        }
    }
    static func parse(_ t: SRDateformatType) -> BDDateformatType{
        switch t {
        case .mmdd: return .mmdd
        case .ddmm: return .ddmm
        }
    }
}

enum BDBrightScreenTimeType: Int, BDEnumtProtocol {
    case short, medium, long
    static var collection: [BDBrightScreenTimeType] = [.short, .medium, .long]
    var text: String {
        switch self {
        case .short: return "3\(SRString.Unit.seconds.locastr)"
        case .medium: return "5\(SRString.Unit.seconds.locastr)"
        case .long: return SRString.Device.bright_long.locastr
        }
    }
    var band_z: SRBrightScreenTimeType {
        switch self {
        case .short: return .short
        case .medium: return .medium
        case .long: return .long
        }
    }
    static func parse(_ t: SRBrightScreenTimeType) -> BDBrightScreenTimeType{
        switch t {
        case .short: return .short
        case .medium: return .medium
        case .long: return .long
        }
    }
}

enum BDAncsAppType: Int, BDEnumtProtocol {
    case wechat, qq, sina, facebook
    case twitter, whatsapp, line, linkin
    case sms, instagram, kakotalk, gmail, skype, email
    
    static var all: [BDAncsAppType] {
        switch BandConnect.protocolType {
        case .series_z: return [wechat, qq, sina, facebook, twitter, whatsapp, line, linkin]
        case .series_s: return [wechat, qq, sina, facebook, twitter, whatsapp, line, linkin, sms]
        }
    }
        
    var band_z: SRAncsAppType {
        switch self {
        case .wechat: return .wechat
        case .qq: return .qq
        case .sina: return .sina
        case .facebook: return .facebook
        
        case .twitter: return .twitter
        case .whatsapp: return .whatsapp
        case .line: return .line
        case .linkin: return .linkin
            
        case .sms:      return .sms
        case .instagram:return .instagram
        case .kakotalk: return .kakotalk
        case .gmail:    return .gmail
        case .skype:    return .skype
        case .email:    return .email
        }
    }
    
    static func parse(_ t: SRAncsAppType) -> BDAncsAppType{
        switch t {
        case .wechat: return .wechat
        case .qq: return .qq
        case .sina: return .sina
        case .facebook: return .facebook
            
        case .twitter: return .twitter
        case .whatsapp: return .whatsapp
        case .line: return .line
        case .linkin: return .linkin
            
        case .sms:      return .sms
        case .instagram:return .instagram
        case .kakotalk: return .kakotalk
        case .gmail:    return .gmail
        case .skype:    return .skype
        case .email:    return .email
        }
    }
    ///: - series_z
    /// 黑名单 -> 白名单
    static func parse(_ list: [SRAncsAppType]) -> [BDAncsAppType]{
        return Set(all).subtracting(Set(list.map({ BDAncsAppType.parse($0) }))).map({ $0 })
    }
    
    /// 白名单 -> 黑名单
    static func parse(_ list: [BDAncsAppType]) -> [SRAncsAppType]{
        return Set(all).subtracting(Set(list)).map({ $0.band_z })
    }

    ///: - series_s
    static func parse(_ m: YFMessageNotifyType) -> [BDAncsAppType] {
        guard m.allSwitch == .on else { return [] }
        var result = [BDAncsAppType]()
        if m.wechat == .on { result.append(.wechat) }
        if m.qq == .on { result.append(.qq) }
        if m.facebook == .on { result.append(.facebook) }
        if m.twitter == .on { result.append(.twitter) }
        if m.whatsapp == .on { result.append(.whatsapp) }
        if m.line == .on { result.append(.line) }
        if m.linkedIn == .on { result.append(.linkin) }
        
        if m.other == .on { result.append(.sina) }
        if m.other == .on { result.append(.sms) }
        return result
    }
    
    static func parse(_ list: [BDAncsAppType]) -> YFMessageNotifyType {
        let m = YFMessageNotifyType()
        m.wechat = list.contains(.wechat) ? .on : .off
        m.qq = list.contains(.qq) ? .on : .off
        m.facebook = list.contains(.facebook) ? .on : .off
        m.twitter = list.contains(.twitter) ? .on : .off
        m.whatsapp = list.contains(.whatsapp) ? .on : .off
        m.line = list.contains(.line) ? .on : .off
        m.linkedIn = list.contains(.linkin) ? .on : .off

        m.other = list.contains(.sina) ? .on : .off
        m.other = list.contains(.sms) ? .on : .off
        
        return m
    }
}

enum BDVibrateType: Int, BDEnumtProtocol {
    case none, staccato, wave, heartbeat, radiate, lighthouse, symphony, quick
    static let collection: [BDVibrateType] = [.none, .staccato, .wave, .heartbeat, .radiate, .lighthouse, .symphony, .quick]
    var name: String {
        switch self {
        case .none: return "无铃声"
        case .staccato: return "断奏"
        case .wave: return "波浪"
        case .heartbeat: return "心跳"
        case .radiate: return "放射"
        case .lighthouse: return "灯塔"
        case .symphony: return "交响乐"
        case .quick: return "快速"
        }
    }
    var band_z: SRVibrateType {
        switch self {
        case .none: return .none
        case .staccato: return .staccato
        case .wave: return .wave
        case .heartbeat: return .heartbeat
        case .radiate: return .radiate
        case .lighthouse: return .lighthouse
        case .symphony: return .symphony
        case .quick: return .quick
        }
    }
    
    static func parse(_ t: SRVibrateType) -> BDVibrateType{
        switch t {
        case .none: return .none
        case .staccato: return .staccato
        case .wave: return .wave
        case .heartbeat: return .heartbeat
        case .radiate: return .radiate
        case .lighthouse: return .lighthouse
        case .symphony: return .symphony
        case .quick: return .quick
        }
    }
}


enum BDRemindType: Int, BDEnumtProtocol {
    case goal, call, message, heart, raiseLight, water, sedentary, nodistrub
    var hasTime: Bool {
        if BandConnect.protocolType == .series_s,
           [.goal, .call, .message, .heart].contains(self) { return false }
        return true
    }
    var hasVibrate: Bool {
        if BandConnect.protocolType == .series_s { return false }
        if [.goal, .heart, .raiseLight, .nodistrub].contains(self) { return false }
        if SRDataManager.userInfo.isAbys, .water == self { return false }
        return true
    }
    var hasInterval: Bool {
        if [.water, .sedentary].contains(self) { return true }
        return false
    }
    var hasNoomDistrub: Bool {
        if .sedentary == self { return true }
        return false
    }
}


