//
//  Animator.swift
//  CTFit
//
//  Created by Shirajo on 2018/9/6.
//  Copyright © 2018年 Shirajo. All rights reserved.
//


import UIKit

/// 动画持有者
class Animator {
    
    internal var displayLink: CADisplayLink? = nil
    internal var startTime: Double = 0.0
    var hasStarted: Bool = false
    var hasStartedAnimating: Bool = false
    var hasFinished: Bool = false
    var isCancelled: Bool = false
    var isManaged: Bool = false
    
    /// 闭包
    var onAnimationStart: () -> Void = {}
    var onAnimationEnd: () -> Void = {}
    var onAnimationUpdate: () -> Void = {}
    var onAnimationCancelled: () -> Void = {}
    
    public func start() {
        hasStarted = true
        isCancelled = false;
        hasFinished = false;
        
        startTime = CACurrentMediaTime()
        if(!isManaged) {
            startDisplayLink()
        }
    }
    
    public func cancel() {
        isCancelled = true
        onAnimationCancelled()
        if(!isManaged) {
            animationTick()
        }
    }
    
    // MARK: - DisplayLink 定时器
    
    internal func startDisplayLink() {
        stopDisplayLink() // make sure to stop a previous running display link
        displayLink = CADisplayLink(target: self, selector: #selector(animationTick))
        displayLink?.add(to: .main, forMode: .common)
    }
    
    internal func stopDisplayLink() {
        displayLink?.invalidate()
        displayLink = nil
    }
    
    @objc internal func animationTick() {
        
    }
    
}
