//
//  AnimatorSet.swift
//  CTFit
//
//  Created by Shirajo on 2018/9/6.
//  Copyright © 2018年 Shirajo. All rights reserved.
//

import UIKit

class AnimatorSet : Animator {
    private var animators: [Animator] = []
    
    var delay: Double = 0
    var playSequential: Bool = false
    
    override func start() {
        super.start()
    }
    
    override func animationTick() {
        // In case this gets called after we finished
        if(hasFinished) {
            return
        }
        
        let elapsed = CACurrentMediaTime() - startTime - delay
        if(elapsed < 0 && !isCancelled) {
            return
        }
        
        if(!hasStartedAnimating) {
            hasStartedAnimating = true
            onAnimationStart()
        }
        
        var finishedNumber = 0
        for animator in animators {
            if(!animator.hasStarted) {
                animator.start()
            }
            animator.animationTick()
            if(animator.hasFinished) {
                finishedNumber += 1
            } else {
                if(playSequential) {
                    break
                }
            }
        }
        
        if(finishedNumber >= animators.count) {
            endAnimation()
        }
    }
    
    private func endAnimation() {
        hasFinished = true
        if(!isManaged) {
            stopDisplayLink()
        }
        onAnimationEnd()
    }
    
    public func addAnimator(_ animator: Animator) {
        animator.isManaged = true
        animators.append(animator)
    }
    
    public func addAnimators(_ animators: [Animator]) {
        for animator in animators {
            animator.isManaged = true
            self.animators.append(animator)
        }
    }
    
    override func cancel() {
        for animator in animators {
            animator.cancel()
        }
        
        super.cancel()
    }
}
