//
//  AnimatorValue.swift
//  CTFit
//
//  Created by Shirajo on 2018/9/6.
//  Copyright © 2018年 Shirajo. All rights reserved.
//

import UIKit

class AnimatorValue : Animator {
    public internal(set) var progress: Double = 0.0
    public internal(set) var interpolatedProgress: Double = 0.0
    
    var duration: Double = 0.3
    var delay: Double = 0
    var interpolator: Interpolator = InterpolatorEasing(ease: .LINEAR)
    
    override func animationTick() {
        // In case this gets called after we finished
        if(hasFinished) {
            return
        }
        
        let elapsed: Double = (isCancelled) ? self.duration : CACurrentMediaTime() - startTime - delay
        
        if(elapsed < 0) {
            return
        }
        
        if(!hasStartedAnimating) {
            hasStartedAnimating = true
            onAnimationStart()
        }
        
        if(duration <= 0) {
            progress = 1.0
        } else {
            progress = min(elapsed / duration, 1.0)
        }
        interpolatedProgress = interpolator.interpolate(elapsedTimeRate: progress)
        
        updateAnimationValues()
        onAnimationUpdate()
        
        if(elapsed >= duration) {
            endAnimation()
        }
    }
    
    private func endAnimation() {
        hasFinished = true
        hasStartedAnimating = false;
        if(!isManaged) {
            stopDisplayLink()
        }
        onAnimationEnd()
    }
    
    internal func updateAnimationValues() {
        
    }
}
