//
//  AnimatorValueCGFloat.swift
//  CTFit
//
//  Created by Shirajo on 2018/9/6.
//  Copyright © 2018年 Shirajo. All rights reserved.
//

import UIKit

class AnimatorValueCGFloat : AnimatorValue {
    var startValue: CGFloat
    var endValue: CGFloat
    public private(set) var animatedValue: CGFloat
    
    override init() {
        startValue = 0;
        endValue = 0;
        animatedValue = startValue;
    }
    
    init(startValue: CGFloat, endValue: CGFloat) {
        self.startValue = startValue
        self.endValue = endValue
        self.animatedValue = startValue
    }
    
    override func updateAnimationValues() {
        animatedValue = startValue + CGFloat(Double(endValue - startValue) * interpolatedProgress)
    }
}
