//
//  InterpolatorEasing.swift
//  CTFit
//
//  Created by Shirajo on 2018/9/6.
//  Copyright © 2018年 Shirajo. All rights reserved.
//

import Foundation

enum Ease {
    case LINEAR  // 线性
    case SINE_IN 
    case SINE_OUT
    case SINE_IN_OUT
    case CIRC_IN
    case CIRC_OUT
    case CIRC_IN_OUT
}

class InterpolatorEasing : Interpolator {
    private let ease: Ease
    
    init(ease: Ease) {
        self.ease = ease
    }
    
    func interpolate(elapsedTimeRate: Double) -> Double {
        switch (ease) {
        case Ease.LINEAR:
            return elapsedTimeRate
        case Ease.SINE_IN:
            return (1.0 - cos(elapsedTimeRate * Double.pi / 2.0))
        case Ease.SINE_OUT:
            return sin(elapsedTimeRate * Double.pi / 2.0)
        case Ease.SINE_IN_OUT:
            return (-0.5 * (cos(Double.pi * elapsedTimeRate) - 1.0))
        case Ease.CIRC_IN:
            return  -(sqrt(1.0 - elapsedTimeRate * elapsedTimeRate) - 1.0)
        case Ease.CIRC_OUT:
            let newElapsedTimeRate = elapsedTimeRate - 1
            return sqrt(1.0 - newElapsedTimeRate * newElapsedTimeRate)
        case Ease.CIRC_IN_OUT:
            var newElapsedTimeRate = elapsedTimeRate * 2.0
            if (newElapsedTimeRate < 1.0) {
                return (-0.5 * (sqrt(1.0 - newElapsedTimeRate * newElapsedTimeRate) - 1.0))
            }
            newElapsedTimeRate -= 2.0
            return (0.5 * (sqrt(1 - newElapsedTimeRate * newElapsedTimeRate) + 1.0))
            
        }
    }
}
