//
//  Colors.swift
//  CTFit
//
//  Created by Mac on 2020/9/11.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

struct Colors {
    
    static func rgb(_ value: UInt32, _ alpha: CGFloat = 1.0)-> UIColor {
        UIColor(rgb: value, alpha: alpha)
    }
    private static func rgb(hexString: String, alpha: CGFloat = 1.0)-> UIColor {
        UIColor(hexString: hexString, alpha: alpha)
    }
    private static func rgb(value: UInt32, alpha: CGFloat = 1.0)-> UIColor {
        UIColor(rgb: value, alpha: alpha)
    }
    
    static func darkMode(_ darkColor: UIColor, _ defaultColor:UIColor) -> UIColor {
        UIColor.darkMode(darkColor, defaultColor)
    }
    
    static let black: UIColor = rgb(0x000000)
    static let black_less: UIColor = rgb(0x1F1F1F)
    static let sportRecordBack: UIColor = rgb(0x22282D)
    static let dark: UIColor = rgb(0x2F2F2F)
    static let darkGray: UIColor = rgb(0x545454)
    static let gray: UIColor = rgb(0x7F7F7F)
    static let lightGray: UIColor = rgb(0xAAAAAA)
    static let white: UIColor = rgb(0xFFFFFF)
    static let blue: UIColor = rgb(0x4CC1D2)
    static let red: UIColor = rgb(0xff4018)
    static let green: UIColor = rgb(0x00f900)
    static let orange: UIColor = rgb(0xFBAB2D)
    static let orangeProgress: UIColor = rgb(0xf7bc30)


    struct NavigationBar {
        static let barTint: UIColor = darkMode(black, black)
        static let tint: UIColor = darkMode(white, white)
        static let foreground: UIColor = darkMode(white, white)
        static let separator: UIColor = darkMode(darkGray, lightGray)
    }
    
    struct TabBar {
        static let barTint: UIColor = darkMode(black, white)
        static let tint: UIColor = darkMode(white, black)
        static let foreground: UIColor = darkMode(white, black)
        static let separator: UIColor = darkMode(darkGray, lightGray)
    }
    
    struct Base {
        static let background: UIColor = darkMode(black, white)
        static let foreground: UIColor = darkMode(white, black)
        static let title: UIColor = darkMode(white, black)
        static let description: UIColor = darkMode(gray, gray)
        static let separator: UIColor = darkMode(darkGray, lightGray)
        static let shadow: UIColor = darkMode(darkGray, lightGray)
    }
    
    struct Cell {
        static let title: UIColor = darkMode(white, black)
        static let description: UIColor = darkMode(gray, gray)
        static let value: UIColor = darkMode(blue, gray)
        static let tint: UIColor = blue
        static let separator: UIColor = darkMode(darkGray, lightGray)
        static let background: UIColor = darkMode(black_less, white)
    }
    
    struct Chart {
        static let segmentGround: UIColor = darkMode(Colors.rgb(0x0f0f0f), Colors.rgb(0xf2f2f2))
        static let text: UIColor = darkMode(white, black)
        static let separator: UIColor = darkMode(darkGray, lightGray)
        static let starNormal: UIColor = darkMode(dark, rgb(0xE0E0E0))
        static let starSelect: UIColor = rgb(0xB09228)
        static let exerciseGroup: [UIColor] = [rgb(0x00ffff), rgb(0xfff45c), rgb(0x00a0e9), rgb(0x8957a1), rgb(0xeb6877)]
    }
    
    struct Heart {
        static let hightest: UIColor = red
        static let lowest: UIColor = blue
        static let average: UIColor = green
    }
    
    /// 随眠状态
    struct Sleep {
        static let wake: UIColor   = rgb(0x94E0FF)
        static let light: UIColor  = rgb(0x5EAEFF)
        static let deep: UIColor   = rgb(0x5580FF)
        static let items: [UIColor] =  [wake, light, deep]
    }
    
    /// 首页圆形菜单 进度渐变色
    struct StepGoal {
        static let green: UIColor   = rgb(0x00FD47)
        static let blue: UIColor    = rgb(0x256DFF)
        static let yellow: UIColor  = rgb(0xF8BE0D)
        static let red: UIColor     = rgb(0xFF0618)
    }
}
