//
//  ImageRepo.swift
//  CTFit
//
//  Created by Mac on 2020/9/11.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

struct ImageRepo {
    
    struct Other {
        static let arrow: UIImage = UIImage(named: "arrow")!
        static let portrait: UIImage = UIImage(named: "portrait")!
        static let previous: UIImage = UIImage(named: "previous")!
        static let next: UIImage = UIImage(named: "next")!
        static let file: UIImage = UIImage(named: "file")!
        static let guide_arrow: UIImage = UIImage(named: "guide_arrow")!
    }
    
    struct Navi {
        static let back = UIImage(named: "back")!.withRenderingMode(.alwaysOriginal)
        static let down = UIImage(named: "down")!.withRenderingMode(.alwaysTemplate)
        static let share = UIImage(named: "share")!.withRenderingMode(.alwaysOriginal)
        static let connected = UIImage(named: "connected")!.withRenderingMode(.alwaysOriginal)
        static let disconnected = UIImage(named: "disconnected")!.withRenderingMode(.alwaysOriginal)
    }
    
    struct HomeCircle {
        static let bacground = UIImage(named: "home_bg")!
        static let steps = UIImage(named: "home_steps")!
        static let distance = UIImage(named: "home_distance")!
        static let calorie = UIImage(named: "home_calorie")!
        static let heartrate = UIImage(named: "home_heartrate")!
        static let steps_larger = UIImage(named: "home_steps_larger")!
        struct Menu {
            static let bacground = UIImage(named: "circle_menu_bg")!
            static let home = UIImage(named: "circle_menu_home")!
            static let gps = UIImage(named: "circle_menu_gps")!
            static let sleep = UIImage(named: "circle_menu_sleep")!
            static let heartrate = UIImage(named: "circle_menu_heartrate")!
            static let settings = UIImage(named: "circle_menu_settings")!
            static let sport = UIImage(named: "circle_menu_sport")!
            static let camera = UIImage(named: "circle_menu_camera")!
        }
    }
    
    struct HomeList {
        static let step = UIImage(named: "ic_list_step")!
        static let heartrate = UIImage(named: "ic_list_heartrate")!
        static let sleep = UIImage(named: "ic_list_sleep")!
        static let exercise = UIImage(named: "ic_list_exercise")!
        static let distance = UIImage(named: "ic_list_distance")!
        static let calorie = UIImage(named: "ic_list_calorie")!
        struct Tabbar {
            static let step1 = UIImage(named: "ic_activity_normal")!
            static let step2 = UIImage(named: "ic_activity_selected")!
            static let agps1 = UIImage(named: "ic_agps_normal")!
            static let agps2 = UIImage(named: "ic_agps_selected")!
            static let setting1 = UIImage(named: "ic_setting_normal")!
            static let setting2 = UIImage(named: "ic_setting_selected")!
        }
    }
    
    struct Camera {
        static let flashlight_on = UIImage(named: "ic_flashlight_on")!
        static let flashlight_off = UIImage(named: "ic_flashlight_off")!
        static let flashlight_auto = UIImage(named: "ic_flashlight_auto")!
        static let lenses_front = UIImage(named: "ic_lenses_front")!
        static let lenses_back = UIImage(named: "ic_lenses_back")!
        static let tack_photo = UIImage(named: "ic_tack_photo")!
        static let play = UIImage(named: "ic_play")!
    }
    
    struct Settings {
        static let personal = UIImage(named: "ic_settings_personal")!
        static let camera = UIImage(named: "ic_settings_camera")!
        static let device = UIImage(named: "ic_settings_device")!
        static let sport = UIImage(named: "ic_settings_sport")!
        static let clock = UIImage(named: "ic_settings_clock")!
        static let application = UIImage(named: "ic_settings_application")!
        static let faq = UIImage(named: "ic_settings_faq")!
        static let ic_clock = UIImage(named: "ic_clock")!
        static let ic_portrait = UIImage(named: "ic_portrait")!
    }
    
    struct App {
        static let qq = UIImage(named: "app_qq")!
        static let wechat = UIImage(named: "app_wechat")!
        static let sina = UIImage(named: "app_sina")!
        static let facebook = UIImage(named: "app_facebook")!
        static let line = UIImage(named: "app_line")!
        static let twitter = UIImage(named: "app_twitter")!
        static let linkin = UIImage(named: "app_linkedin")!
        static let whatsapp = UIImage(named: "app_whatsapp")!
        static let sms = UIImage(named: "app_msm")!
    }
    
    struct SportTypes {
        static let normal = UIImage(named: "walk")!
        static let run = UIImage(named: "run")!
        static let climbing = UIImage(named: "climbing")!
        static let indoor = UIImage(named: "walk")!
        static let swiming = UIImage(named: "swiming")!
        static let yoga = UIImage(named: "walk")!

        static let walk = UIImage(named: "walk")!
        static let badminton = UIImage(named: "badminton")!
        static let basketball = UIImage(named: "basketball")!
        static let football = UIImage(named: "football")!
        static let pingPong = UIImage(named: "pingPong")!
        static let tennis = UIImage(named: "walk")!
        static let bike = UIImage(named: "bike")!
        static let indoorRun = UIImage(named: "indoorRun")!
    }
    
    struct Sport {
        static let bg_weather = UIImage(named: "sport_bg_weather")!
        static let bg_control = UIImage(named: "sport_bg_control")!
        static let bg_heart = UIImage(named: "sport_bg_heart")!
        
        static let start = UIImage(named: "sport_start")!
        static let stop = UIImage(named: "sport_stop")!
        static let voice_enable = UIImage(named: "voice_enable")!
        static let voice_disable = UIImage(named: "voice_disable")!
        
        static let location_arrow = UIImage(named: "location_arrow")!
        static let map_scale = UIImage(named: "map_scale")!
        static let track_start = UIImage(named: "track_start")!
        static let track_end = UIImage(named: "track_end")!
        static let location_user_normal = UIImage(named: "location_user_normal")!
        static let location_user_highlight = UIImage(named: "location_user_highlight")!
        static let agps_signal0 = UIImage(named: "agps_signal0")!
        static let agps_signal1 = UIImage(named: "agps_signal1")!
        static let agps_signal2 = UIImage(named: "agps_signal2")!
        static let agps_signal3 = UIImage(named: "agps_signal3")!
        static let agps_signal4 = UIImage(named: "agps_signal4")!
        static let agps_signal5 = UIImage(named: "agps_signal5")!
        static let agps_signal6 = UIImage(named: "agps_signal6")!

        static let normal = UIImage(named: "normal")!
        static let selected = UIImage(named: "selected")!
        
        static let pace_speed = UIImage(named: "pace_speed")!
        static let realtime_speed = UIImage(named: "realtime_speed")!
    }
   
    struct Weather {
        static let fineDay: UIImage = UIImage(named: "weather_fine_day")!
        static let cloudy: UIImage = UIImage(named: "weather_over_cast")!
        static let overCast = UIImage(named: "weather_over_cast")!
        static let lightRain = UIImage(named: "weather_light_rain")!
        static let moderateRain = UIImage(named: "weather_moderate_rain")!
        static let heavyRain = UIImage(named: "weather_heavy_rain")!
        static let shower = UIImage(named: "weather_shower")!
        static let snow = UIImage(named: "weather_snow")!
        static let haze = UIImage(named: "weather_haze")!
        static let sandStorm = UIImage(named: "weather_sand_storm")!
        static let cloudyToFine = UIImage(named: "weather_cloudy_fine")!
        static let thunderStorm = UIImage(named: "weather_thunder_storm")!
        static let unknown = UIImage(named: "weather_unknown")!
    }
    
    struct Step {
        static let bg_day: UIImage = UIImage(named: "bg_step_day")!
        static let bg_week: UIImage = UIImage(named: "bg_step_week")!
        static let bg_month = UIImage(named: "bg_step_month")!
        static let bg_year = UIImage(named: "bg_step_year")!
        static let rating_star_empty = UIImage(named: "ic_rating_star_empty")!
        static let rating_star_full = UIImage(named: "ic_rating_star_full")!
        static let trophy = UIImage(named: "ic_trophy")!
    }
    
    struct Heart {
        static let bg: UIImage = UIImage(named: "bg_heart")!
    }
    
    struct Sleep {
        static let bg_day: UIImage = UIImage(named: "bg_sleep_day")!
        static let bg_week: UIImage = UIImage(named: "bg_sleep_week")!
        static let bg_month = UIImage(named: "bg_sleep_month")!
        static let bg_year = UIImage(named: "bg_sleep_year")!
    }
    
    struct Detect {
        static let heart: UIImage = UIImage(named: "detect_heart")!
        static let pressure: UIImage = UIImage(named: "detect_pressure")!
    }
}
