//
//  SRString.swift
//  CTFit
//
//  Created by Mac on 2020/9/11.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation

// MARK: - SLProtocol
protocol SLProtocol: CustomStringConvertible, RawRepresentable where RawValue == String {
    var locastr: String { get }
}

extension SLProtocol {
    var locastr: String { NEString(rawValue) }
    var description: String { NEString(rawValue) }
}

extension String {
    var locastr: String { NEString(self) }
}

struct SRString {
    // MARK: - 通用
    enum Base: String, SLProtocol {
        case alert  = "alert"
        case ok     = "ok"
        case cancel = "cancel"
        case yes    = "yes"
        case no     = "no"
        case day    = "day"
        case week   = "week"
        case month  = "month"
        case year   = "year"
        case save   = "save"
        case add    = "add"
        case delete = "delete"
        case opened = "opened"
        case closed = "closed"
        case retry  = "retry"
        case agree = "agree"
        case disagree = "disagree"
        case saving = "saving"
        case saved_success = "saved_success"
        case saved_failed = "saved_failed"
        case turn_on_off = "turn_on_off"
        case no_setting = "no_setting"
        case ble_off = "ble_off"
        case request_timeout = "request_timeout"
        case disconnect_band = "disconnect_band"
        case nodata_describe = "nodata_describe"
        case nodata_describe_step = "nodata_describe_step"
        case nodata_describe_sleep = "nodata_describe_sleep"
        case nodata_describe_heart = "nodata_describe_heart"
        case nodata_describe_heart_sleep = "nodata_describe_heart_sleep"
        case nodata_describe_heart_exercise = "nodata_describe_heart_exercise"
        case nodata_describe_detect_heart = "nodata_describe_detect_heart"
        case nodata_describe_detect_pressure = "nodata_describe_detect_pressure"
        case no_connected_device = "no_connected_device"
        case sure_readed_alert = "sure_readed_alert"
        case guide_pair_message = "guide_pair_message"
    }
    
    // MARK: - 单位
    enum Unit: String, SLProtocol {
        case hours = "hours"
        case minute = "minute"
        case hour = "hour"
        case min = "min"
        case seconds = "seconds"
        /// 公制
        case metric = "metric"
        case km = "km"
        case m  = "m"
        case cm = "cm"
        case kg = "kg"
        case km_ph = "km_ph"
        /// 英制
        case imperial = "imperial"
        case mile   = "mile"
        case foot   = "foot"
        case inch   = "inch"
        case lb     = "lb"
        case mile_ph = "mile_ph"
    }
    
    // MARK: - 搜索设备
    enum Searched: String, SLProtocol {
        case searching = "searching"
        case connecting = "connecting"
        case search_device = "search_device"
        case connect_timeout = "connect_timeout"
        case connect_failed = "connect_failed"
        case pairlost_alert = "pairlost_alert"
    }
    
    
    // MARK: - 我的设备
    enum Connected: String, SLProtocol {
        case mydevice = "device"
        case device_connected = "device_connected"
        case device_operation = "device_operation"
        // MARK: 拍照
        case take_picture = "take_picture"
        case denied_permission_camera_message = "denied_permission_camera_message"
        case denied_permission_library_message = "denied_permission_library_message"
        // MARK: 寻找设备
        case findband = "findband"
        case findband_alert = "findband_alert"
        // MARK: 恢复出厂设置
        case reset = "reset"
        case reset_alert = "reset_alert"
        // MARK: 删除设备
        case deleting = "deleting"
        case delete_device = "delete_device"
        case delete_device_alert = "delete_device_alert"
        case unbind_alert = "unbind_alert"
    }
    
    // MARK: - 固件升级
    enum Upgrade: String, SLProtocol {
        case update_firmwre = "update_firmwre"
        /// 检测
        case checking = "checking"
        case version_latested = "version_latested"
        case version_checked_alert = "version_checked_alert"
        case version_check_failed_alert = "version_check_failed_alert"
        /// 升级
        case update_firmwre_declare = "update_firmwre_declare"
        case upgrade_successed = "upgrade_successed"
        case upgrade_failed = "upgrade_failed"
        case loading = "loading"
        case fm_downloading = "fm_downloading"
        case fm_download_failed = "fm_download_failed"
        case fm_download_failed_alert = "fm_download_failed_alert"
        case fm_invalid_file_alert = "fm_invalid_file_alert"
        case enter_upgrade_mode = "enter_upgrade_mode"
        case find_upgrade_device = "find_upgrade_device"
        case find_upgrade_device_failed_alert = "find_upgrade_device_failed_alert"
        case fm_uploading = "fm_uploading"
        case fm_upload_interrupt = "fm_upload_interrupt"
        case fm_upload_retry_alert = "fm_upload_retry_alert"
    }
    
    // MARK: - 设置
    enum Settings: String, SLProtocol {
        case settings = "settings"
        case personal = "settings_personal"
        case device = "settings_device"
        case sport = "settings_sport"
        case clock = "settings_clock"
        case application = "application"
        case faq = "faq"
    }
    
    // MARK: - 个人
    enum Personal: String, SLProtocol {
        case nickname = "nickname"
        case age = "age"
        case gender = "gender"
        case male = "male"
        case female = "female"
        case height = "height"
        case weight = "weight"
        case hand_type = "hand_type"
        case hand_left = "hand_left"
        case hand_right = "hand_right"
    }
    
    // MARK: - 设备设置
    enum Device: String, SLProtocol {
        case device = "device"
        case remind_interval = "remind_interval"
        // MARK: 时间制
        case hourly_set = "hourly_set"
        case hourly_h12 = "hourly_h12"
        case hourly_h24 = "hourly_h24"
        // MARK: 公英制
        case system_unit = "system_unit"
        case metric = "metric"
        case imperial = "imperial"
        // MARK: 温度单位
        case temp_unit = "temp_unit"
        case centigrade = "centigrade"
        case fahrenheit = "fahrenheit"
        // MARK: 日期格式
        case dateformat = "dateformat"
        case dateformat_mmdd = "dateformat_mmdd"
        case dateformat_ddmm = "dateformat_ddmm"
        // MARK: 亮屏时间
        case bright_screen_time = "bright_screen_time"
        case bright_long = "bright_long"
        // MARK: 来电提醒
        case reminder_incoming = "reminder_incoming"
        case reminder_incoming_period = "reminder_incoming_period"
        // MARK: 信息推送
        case notify_message = "notify_message"
        case notify_message_period = "notify_message_period"
        case notify_message_type = "notify_message_type"
        case notify_message_enable = "notify_message_enable"
        case notify_message_disable = "notify_message_disable"
        // MARK: 心率监测
        case heart_monitor = "heart_monitor"
        // MARK: 翻腕亮屏
        case roll_brightscrren = "roll_brightscrren"
        // MARK: 喝水提醒
        case drinkwater_reminder = "drinkwater_reminder"
        // MARK: 勿扰模式
        case no_distrub = "no_distrub"
    }
        
    // MARK: - 运动设置
    enum SportSet: String, SLProtocol {
        case stride_walk = "stride_walk"
        case stride_run = "stride_run"
        case goal_steps = "goal_steps"
        case goal_calories = "goal_calories"
        case goal_distance = "goal_distance"
        case reminder_target = "reminder_target"
        case reminder_heart_high = "reminder_heart_high"
        case reminder_heart_low = "reminder_heart_low"
        case reminder_heart_high_describe = "reminder_heart_high_describe"
        case reminder_heart_low_describe = "reminder_heart_low_describe"
        case reminder_sedentary = "reminder_sedentary"
    }
        // MARK: - 闹钟设置
    enum Clock: String, SLProtocol {
        case clock_setting = "clock_setting"
        case clock_reminder = "clock_reminder"
        case clock_reminder_add = "clock_reminder_add"
        case schedules_reminder = "schedules_reminder"
        case schedules_reminder_add = "schedules_reminder_add"
        case repeat_none = "repeat_none"
        case repeat_everyday = "repeat_everyday"
        case repeat_workday = "repeat_workday"
        case label = "label"
        case label_placeholder = "label_placeholder"
        case label_hint_clock = "label_hint_clock"
        case label_hint_schedule = "label_hint_schedule"
        case delete_clock_alert = "delete_clock_alert"
        case delete_schedule_alert = "delete_schedule_alert"
        case saved_clock_success = "saved_clock_success"
        case saved_clock_failed = "saved_clock_failed"
    }
        
    // MARK: - 应用
    enum Application: String, SLProtocol {
        case sound_effect = "sound_effect"
        case home_style_switch = "home_style_switch"
        case apple_health = "apple_health"
        case apple_health_describe = "apple_health_describe"
        // MARK: 个人数据
        case personal_data = "personal_data"
        case no_file = "no_file"
        case export = "export"
        case exporting = "exporting"
        case export_success = "export_success"
        // MARK: 删除个人数据
        case personal_data_delete = "personal_data_delete"
        case personal_data_delete_alert = "personal_data_delete_alert"
        case personal_data_deleted = "personal_data_deleted"
        // MARK: 问题反馈
        case feedback = "feedback"
        // MARK: 关于
        case about = "about"
        case application_version = "application_version"
    }
    
    // MARK: 时间段
    enum Period: String, SLProtocol {
        case allow_period = "allow_period"
        case allow_period_describe = "allow_period_describe"
        case start_time = "start_time"
        case end_time = "end_time"
        case reminder_interval = "reminder_interval"
    }
    
    // MARK: 振动
    enum Vibrate: String, SLProtocol {
        case vibrate = "vibrate"
        case vibrate_type = "vibrate_type"
        case vibrate_number = "vibrate_number"
        case vibrate_non = "vibrate_non"
        case staccato = "staccato"
        case wave = "wave"
        case heartbeat = "heartbeat"
        case radiate = "radiate"
        case lighthouse = "lighthouse"
        case symphony = "symphony"
        case quick = "quick"
        case `repeat` = "repeat"
    }
    
    // MARK: - Gps 运动
    enum Sport: String, SLProtocol {
        case sport = "sport"
        case sport_mode = "sport_mode"
        case distance = "distance"
        case speed = "speed"
        case time = "time"
        case unit_time = "unit_time"
        case gps_voice_start = "gps_voice_start"
        case gps_voice_end = "gps_voice_end"
        case gps_voice_reminder_km = "gps_voice_reminder_km"
        case gps_voice_reminder_mile = "gps_voice_reminder_mile"
        case longpress_sport_end = "longpress_sport_end"
        case band_start_gps_notify = "band_start_gps_notify"
        case band_stop_gps_notify = "band_stop_gps_notify"
        case band_start_gps_alert = "band_start_gps_alert"
        case denied_permission_location_message = "denied_permission_location_message"
        case sport_history = "sport_history"
        case sport_history_nodata = "sport_history_nodata"
        case detail = "detail"
        case track = "track"
        case pace_speed = "pace_speed"
        case pace_speed_fastest = "pace_speed_fastest"
        case pace_speed_average = "pace_speed_average"
        case pace_speed_slowest = "pace_speed_slowest"
        case use_time = "use_time"
        case realtime_speed = "realtime_speed"
        case fastest = "fastest"
        case average = "average"
        case slowest = "slowest"
        case consume = "consume"
        case today = "today"
        case yesterday = "yesterday"
    }

    // MARK: 计步
    enum Step: String, SLProtocol {
        case step = "step"
        case calories_cr = "calories_cr"
        case step_count = "step_count"
        case unit_step = "unit_step"
        case unit_calories = "unit_calories"
        case standard_reach_rate = "standard_reach_rate"
        case movement = "movement"
        case trophy = "trophy"
    }
    
    // MARK: 训练
    enum Exercise: String, SLProtocol {
        case walk = "walk"
        case run = "run"
        case bike = "bike"
        case climbing = "climbing"
        case indoor_run = "indoor_run"
        case indoor = "indoor"
        case swiming = "swiming"
        case yoga = "yoga"
        case badminton = "badminton"
        case basketball = "basketball"
        case football = "football"
        case pingpong = "pingpong"
        case tennis = "tennis"
        case exercise_time = "exercise_time"
        case calories_burn = "calories_burn"
        case average_pace_step = "average_pace_step"
        case highest_pace_step = "highest_pace_step"
        case exercise_statistic = "exercise_statistic"
    }
    
    // MARK: 睡眠
    enum Sleep: String, SLProtocol {
        case sleep = "sleep"
        case light_sleep = "light_sleep"
        case deep_sleep = "deep_sleep"
        case wake = "wake"
        case total_sleep = "total_sleep"
        case sleep_detail = "sleep_detail"
        case sleep_time = "sleep_time"
        case average = "average"
        case total_deep = "total_deep"
    }
    
    // MARK: 心率
    enum Heart: String, SLProtocol {
        case heart_rate = "heart_rate"
        case average_heart_rate = "average_heart_rate"
        case hightest_heart_rate = "hightest_heart_rate"
        case lowest_heart_rate = "lowest_heart_rate"
        case bpm = "bpm"
    }
    
    // MARK: 血压
    enum BP: String, SLProtocol {
        case blood_pressure = "blood_pressure"
        case systolic_pressure = "systolic_pressure"
        case diastolic_pressure = "diastolic_pressure"
        case mmhg_reference = "mmhg_reference"
        case mmhg = "mmhg"
    }
    
    // MARK: 检测
    enum Detect: String, SLProtocol {
        case manual_detect = "manual_detect"
        case manual_input = "manual_input"
        case detect_start = "detect_start"
        case detecting = "detecting"
        case latest_records = "latest_records"
    }
    
    // MARK: Tabbar home
    enum Tabbar: String, SLProtocol {
        case home = "home"
        case agps = "agps"
        case setting = "settings"
    }
    
    // MARK: ImagePicker
    enum ImagePicker: String, SLProtocol {
        case preview = "preview"
        case album = "album"
        case crop = "crop"
    }    
}
