//
//  BaseNavigationController.swift
//  ctband
//
//  Created by Mac on 2020/4/17.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import NavigationExtension
class BaseNavigationController: UINavigationController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.black
        self.jz_navigationBarTransitionStyle = JZNavigationBarTransitionStyleSystem;
        self.jz_fullScreenInteractivePopGestureEnabled = true;
        self.jz_toolbarBackgroundAlpha = 0.0
        navigationBar.isTranslucent = false;
        navigationBar.barStyle = .black;

        navigationBar.barTintColor = Colors.NavigationBar.barTint;
        navigationBar.tintColor = Colors.NavigationBar.tint;
        navigationBar.titleTextAttributes = [NSAttributedString.Key.foregroundColor: Colors.NavigationBar.foreground,
                                             NSAttributedString.Key.font: UIFont.mediumCustomFont(ofSize: 18)] ;
        navigationBar.setBackgroundImage(UIImage(), for: .default)
        navigationBar.shadowImage = navBarShadowImage()
    }
    
    override func traitCollectionDidChange(_ previousTraitCollection: UITraitCollection?) {
        navigationBar.shadowImage = navBarShadowImage()
    }
}

extension BaseNavigationController {
    func navBarShadowImage() -> UIImage? {
        UIGraphicsBeginImageContextWithOptions(CGSize(width: UIDevice.scrWidth, height: 0.5), false, 0)
        let path = UIBezierPath.init(rect: CGRect.init(x: 0, y: 0, width: UIDevice.scrWidth, height: 0.5))
        /// 自定义NavigationBar分割线颜色
        // Colors.darkMode(.red, .green).setFill()
        Colors.NavigationBar.separator.setFill()
        path.fill()
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return image
    }
}
