//
//  SRFilePreviewManager.swift
//  CTFit
//
//  Created by Mac on 2020/12/15.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import QuickLook

class SRFilePreviewViewController: UIViewController {
    
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
           fatalError("init(coder:) has not been implemented")
    }
        
    init() {
        super.init(nibName: nil, bundle: nil)
        modalPresentationStyle = .fullScreen
    }
    
    convenience init(_ fileURL: URL) {
        self.init()
        filePath = fileURL
    }
    
    override func viewWillLayoutSubviews() {
        super.viewWillLayoutSubviews()
        containerView.frame = self.view.bounds
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.addSubview(containerView)
        self.addChild(quickLookPreviewController)
        containerView.addSubview(quickLookPreviewController.view)
        quickLookPreviewController.view.frame = containerView.bounds
        quickLookPreviewController.didMove(toParent: self)
    }
    
    /// : -  Private fields
    private var filePath: URL?

    private lazy var containerView = UIView()
    
    fileprivate lazy var quickLookPreviewController: QLPreviewController = QLPreviewController()
}

class SRFilePreviewItem: NSObject, QLPreviewItem {
    var filePath: URL?
    public var previewItemURL: URL? {
        if let filePath = filePath {
            return filePath
        }
        return nil
    }
    
}

class SRFilePreviewManager: NSObject, QLPreviewControllerDataSource {
    
    private var filePath: URL?

    func numberOfPreviewItems(in controller: QLPreviewController) -> Int {
        return 1
    }
    
    func previewController(_ controller: QLPreviewController, previewItemAt index: Int) -> QLPreviewItem {
        let item = SRFilePreviewItem()
        if let filePath = filePath {
            item.filePath = filePath
        }
        return item
    }
    
    func instanced(for fileURL: URL, fromNavigation: Bool = false) -> UIViewController {
        self.filePath = fileURL
        let vc = SRFilePreviewViewController()
        vc.quickLookPreviewController.dataSource = self
        if fromNavigation == true { return vc.quickLookPreviewController }
        return vc
    }
    
}
