//
//  DateBarDelegate.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

protocol DateBarDelegate {
    
    typealias Callback = () -> Void
    
    var callback: Callback? { get set }

    var minDate :Date { get set }
    
    var maxDate: Date { get set }
    
    func initialize() ;
    
    func reset();
    
    func titleText() -> String;
    
    func isTodaySelected() -> Bool;
    
    func shouldShowPreButton() -> Bool;
    func onPreAction() -> Bool ;
    
    func shouldShowNextButton() -> Bool;
    func onNextAction() -> Bool ;
    
    func onTitleClicked(viewController: UIViewController?);
}
