//
//  DayDateBarDelegate.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class DayDateBarDelegate {
    
    var callback: DateBarDelegate.Callback? = nil
        
    var date: Date!
    
    var _minDate: Date!
    
    var _maxDate: Date!
    
    private lazy var calendar = CalendarUtils.calendar

    private lazy var dateFormatter :DateFormatter = {
        let formatter = DateFormatter();
        formatter.dateFormat = "yyyy-MM-dd";
        return formatter;
    }()
    
    /// calendarPicker
    
    private lazy var dialog: Dialog = Dialog(with: .top)

    private func createCalendarPicker() -> CalendarPicker {
        let picker = CalendarPicker();
        picker.selectedDate = date
        picker.minDate = _minDate
        picker.maxDate = _maxDate
        return picker;
    }
    
    private func popCalendarPicker() {
        let calendarPicker = createCalendarPicker()
        dialog.pop(calendarPicker, completed: { (_) in
        }, dismissClosure: { [weak self] pick in
            guard let strong = self, let calendarPicker = pick as? CalendarPicker  else { return }
            guard !CalendarUtils.inSameDay(strong.date, calendarPicker.selectedDate) else { return }
            strong.date = calendarPicker.selectedDate
            if let hasCallback = strong.callback { hasCallback() }
        })
    }
}

// MARK: - DateBarDelegate
extension DayDateBarDelegate :DateBarDelegate {
    
    var minDate: Date {
        get{ return _minDate }
        set{ _minDate = newValue}
    }
    
    var maxDate: Date {
        get { return _maxDate }
        set { _maxDate = newValue}
    }
    
    func initialize() {
        date = Date();
    }
    
    func reset() {
        initialize();
    }
    
    func titleText() -> String {
        return dateFormatter.string(from: date);
    }

    func isTodaySelected() -> Bool {
        return calendar.isDateInToday(date);
    }
    
    func shouldShowPreButton() -> Bool {
        let result = calendar.compare(date, to: minDate, toGranularity: .day);
        return result == .orderedDescending;
    }
    
    func onPreAction() -> Bool {
        let newDate = calendar.date(byAdding: .day, value: -1, to: date);
        date = newDate;
        return true;
    }
    
    func shouldShowNextButton() -> Bool {
        let result = calendar.compare(date, to: maxDate, toGranularity: .day);
        return result == .orderedAscending;
    }
    
    func onNextAction() -> Bool {
        let newDate = calendar.date(byAdding: .day, value: 1, to: date)
        date = newDate;
        return true;
    }
    
    func onTitleClicked(viewController: UIViewController?) {
        popCalendarPicker()
    }
}
