//
//  MonthDateBarDelegate.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class MonthDateBarDelegate {
    
    var callback: DateBarDelegate.Callback?
    
    var monthInterval: DateInterval!;

    var _minDate: Date!;
     
    var _maxDate: Date!;
    
    private var today: Date { Date() }
   
    private lazy var calendar = CalendarUtils.calendar

    private lazy var formatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "MM";
        return fm;
    }()
    
}

// MARK: - DateBarDelegate
extension MonthDateBarDelegate: DateBarDelegate {
    var minDate: Date {
        get{ return _minDate }
        set{ _minDate = newValue}
    }
    
    var maxDate: Date {
        get { return _maxDate }
        set { _maxDate = newValue}
    }
    
    
    func initialize() {
        monthInterval = calendar.thisMonth(full: true);
    }
    
    func setMonthInterval(_ date: Date) {
        monthInterval = calendar.monthInterval(containing: date);
    }
    
    func reset() {
        initialize();
    }
    
    func titleText() -> String {
        let isSameYear = calendar.isSame(in: .year, date: monthInterval.start, to: today);
        if isSameYear {
            formatter.dateFormat = "MMM";
        } else {
            formatter.dateFormat = "yyyy-MMM";
        }
        return formatter.string(from: monthInterval.start);
    }
    
    func isTodaySelected() -> Bool {
        return calendar.isSame(in: .year, date: monthInterval.start, to: today) && calendar.isSame(in: .month, date: monthInterval.start, to: today);
    }
    
    func shouldShowPreButton() -> Bool {
        let result = calendar.compare(monthInterval.start, to: minDate, toGranularity: .month);
        return result == .orderedDescending;
    }
    
    func onPreAction() -> Bool {
        monthInterval = calendar.monthBefore(date: monthInterval.start);
        return true;
    }
    
    func shouldShowNextButton() -> Bool {
        let result = calendar.compare(monthInterval.end, to: maxDate, toGranularity: .month);
        return result == .orderedAscending;
    }
    
    func onNextAction() -> Bool {
        monthInterval = calendar.monthNext(date: monthInterval.start);
        return true;
    }
    
    func onTitleClicked(viewController: UIViewController?) {
        
    }
}


