//
//  WeekDateBarDelegate.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit


class WeekDateBarDelegate {
    
    var callback: DateBarDelegate.Callback?
    
    var weekInterval: DateInterval!;
    
    var _minDate: Date!;
    
    var _maxDate: Date!;

    private lazy var calendar = CalendarUtils.calendar

    private lazy var formatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "yyyy-MM-dd";
        return fm;
    }()
    
    func setWeekInterval(_ date: Date) { weekInterval = calendar.weekInterval(containing: date, false) }
}

// MARK: - DateBarDelegate
extension WeekDateBarDelegate: DateBarDelegate{
    
    var minDate: Date {
        get{ return _minDate }
        set{ _minDate = newValue}
    }
    
    var maxDate: Date {
        get { return _maxDate }
        set { _maxDate = newValue}
    }
    
    func initialize() { weekInterval = calendar.thisWeek() }
        
    func reset() {
        initialize();
    }
    
    func titleText() -> String {
        /* 三种情况
         * 1、同年同月
         * 2、同年不同月
         * 3、不同年
         */
        let sameYear = calendar.isSame(in: .year, date: weekInterval.start, to: weekInterval.end);
        let sameMonth = calendar.isSame(in: .month, date: weekInterval.start, to: weekInterval.end);
        
        var startText: String!;
        var endText: String!;
        if sameYear && sameMonth {
            formatter.dateFormat = "MMM d";
            startText = formatter.string(from: weekInterval.start);
            formatter.dateFormat = "d"
            endText = formatter.string(from: weekInterval.end);
        } else if sameYear && !sameMonth {
            formatter.dateFormat = "MMM d";
            startText = formatter.string(from: weekInterval.start);
            endText = formatter.string(from: weekInterval.end);
        } else {
            formatter.dateFormat = "yyyy MMM d";
            startText = formatter.string(from: weekInterval.start);
            endText = formatter.string(from: weekInterval.end);
        }
        return String(format: "%@-%@", startText, endText);
    }
    
    
    
    func isTodaySelected() -> Bool {
        return calendar.isDateInWeekend(weekInterval.start);
    }
    
    func shouldShowPreButton() -> Bool {
        let result = calendar.compare(weekInterval.start, to: minDate, toGranularity: .day);
        return result == .orderedDescending;
    }
    
    func onPreAction() -> Bool {
        weekInterval = calendar.weekBefore(date: weekInterval.start);
        return true;
    }
    
    func shouldShowNextButton() -> Bool {
        let result = calendar.compare(weekInterval.end, to: maxDate, toGranularity: .day);
        return result == .orderedAscending;
    }
    
    func onNextAction() -> Bool {
        weekInterval = calendar.weekNext(date: weekInterval.end);
        return true;
    }
    
    func onTitleClicked(viewController: UIViewController?) {
        
    }
}
