//
//  YearDateBarDelegate.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class YearDateBarDelegate {
    
    var callback: DateBarDelegate.Callback?
    
    // MARK: - Custom

    let today: Date = Date();

    var yearInterval: DateInterval!;
    
    var _minDate: Date!;
    
    var _maxDate: Date!;
    
    private lazy var calendar = CalendarUtils.calendar

    private lazy var formatter :DateFormatter = {
        let fm = DateFormatter();
        fm.dateFormat = "yyyy";
        return fm;
    }()
    
}
// MARK: - DateBarDelegate
extension YearDateBarDelegate: DateBarDelegate {

    var minDate: Date {
        get{ return _minDate }
        set{ _minDate = newValue}
    }
    
    var maxDate: Date {
        get { return _maxDate }
        set { _maxDate = newValue}
    }
    
    func initialize() {
        yearInterval = calendar.thisYear(full: false);
    }
    
    func setYearInterval(_ date: Date) {
        yearInterval = calendar.yearInterval(containing: date);
    }
    
    func reset() {
        initialize();
    }
    
    func titleText() -> String {
        return formatter.string(from: yearInterval.start);
    }
    
    
    func isTodaySelected() -> Bool {
        return calendar.isSame(in: .year, date: yearInterval.start, to: today);
    }
    
    func shouldShowPreButton() -> Bool {
        let result = calendar.compare(yearInterval.start, to: minDate, toGranularity: .year);
        return result == .orderedDescending;
    }
    
    func onPreAction() -> Bool {
        yearInterval = calendar.yearBefore(year: yearInterval.start);
        return true;
    }
    
    func shouldShowNextButton() -> Bool {
        let result = calendar.compare(yearInterval.end, to: maxDate, toGranularity: .year);
        return result == .orderedAscending;
    }
    
    func onNextAction() -> Bool {
        yearInterval = calendar.yearNext(year: yearInterval.start);
        if isTodaySelected(){
            yearInterval = calendar.thisYear(full: false);
        }
        return true;
    }
    
    func onTitleClicked(viewController: UIViewController?) {
        
    }
}
