//
//  Calendar+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

extension Calendar {
    
    // MARK: - Week
    var sunday:     Int { 1 }
    var monday:     Int { 2 }
    var tuesday:    Int { 3 }
    var wednesday:  Int { 4 }
    var thursday:   Int { 5 }
    var friday:     Int { 6 }
    var saturday:   Int { 7 }
    
    
    
    // MARK : - Week Interval
    func weekInterval(containing date: Date, _ startFromMonday: Bool = false) -> DateInterval {
        var firstOfWeek = sunday;
        var lastOfWeek = saturday;
        var weekday = self.component(.weekday, from: date);
        
        if startFromMonday {
            firstOfWeek = monday;
            lastOfWeek = sunday;
            if weekday == sunday {
                weekday += 7;
            }
        }
        
        let start: Date = self.date(byAdding: .day, value: (firstOfWeek - weekday), to: date) ?? date;
        let end: Date = self.date(byAdding: .day, value: (lastOfWeek - weekday), to: date) ?? date;
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));

    }
    
    func thisWeek(_ startFromMonday:Bool = false) -> DateInterval! {
        return weekInterval(containing: Date(), startFromMonday);
    }
    
    func weekBefore(date: Date,_ startFromMonday:Bool = false) -> DateInterval {
        let beforeWeekendDate = self.date(byAdding: .day, value: -7, to: date);
        return weekInterval(containing: beforeWeekendDate!, startFromMonday);
    }
    
    func weekNext(date: Date,_ startFromMonday:Bool = false) -> DateInterval {
        let afterWeekendDate = self.date(byAdding: .day, value: 7, to: date);
        return weekInterval(containing: afterWeekendDate!, startFromMonday);
    }
    
    // MARK: - Month Interval
    func daysInMonth(forDate date:Date) -> Int {
        return self.range(of: .day, in: .month, for: date)!.count;
    }
    
    func startOfMonth(month: Date) -> Date {
        return self.date(bySetting: .month, value: 1, of: month)!;
    }
    
    func monthInterval(containing date: Date) -> DateInterval {
        let days = daysInMonth(forDate: date);
        let now = self.component(.day, from: date);
        let start: Date = self.date(byAdding: .day, value: (1 - now), to: date) ?? date;
        let end: Date = self.date(byAdding: .day, value: (days - now), to: date) ?? date;
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));
    }
    
    func thisMonth(full: Bool) -> DateInterval {
        let today = Date();
        if full {
            return monthInterval(containing: today);
        } else {
            let now = self.component(.day, from: today);
            let start: Date = self.date(byAdding: .day, value: (1 - now), to: today) ?? today;
            return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: today));
        }
    }
    
    func monthBefore(date: Date) -> DateInterval {
        let before = self.date(byAdding: .month, value: -1, to: date);
        return monthInterval(containing:before!);
    }
    
    func monthNext(date: Date) -> DateInterval {
        let after = self.date(byAdding: .month, value: 1, to: date);
        return monthInterval(containing:after!);
    }
    
    
    // MARK: - Year Interval
    
    /// 一年的开始日期
    func startOfYear(year: Date) -> Date {
        let year = self.component(.year, from: year);
        var dateComponents = DateComponents();
        dateComponents.year = year;
        dateComponents.month = 1;
        dateComponents.day = 1;
        return self.date(from: dateComponents)!;
    }
    /// 一年的结束日期
    func endOfYear(year: Date) -> Date {
        let year = self.component(.year, from: year);
        var dateComponents = DateComponents();
        dateComponents.year = year;
        dateComponents.month = 12;
        dateComponents.day = 31;
        return self.date(from: dateComponents)!;
    }
    
    /// 一年的第多少天
    func daysOfYear(toEnd: Date) -> Int {
        let components: DateComponents = dateComponents([.day], from: startOfYear(year: toEnd), to: toEnd)
        return components.day! + 1;
    }
    
    
    func yearInterval(containing date: Date, full: Bool = true ) -> DateInterval {
        let today = date;
        let start = startOfYear(year: today);
        var end: Date;
        if full {
            end = endOfYear(year: today);
        } else {
            end = today;
        }
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));
    }
    
    /// 这一年的日期时间段， full 表示整年， 否则算到今天
    func thisYear(full: Bool) -> DateInterval {
        let today = Date();
        let start = startOfYear(year: today);
        var end: Date;
        if full {
            end = endOfYear(year: today);
        } else {
            end = today;
        }
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));
    }
    
    func yearBefore(year: Date) -> DateInterval {
        let before: Date = self.date(byAdding: .year, value: -1, to: year) ?? year;
        let start = startOfYear(year: before);
        let end = endOfYear(year: before);
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));
    }
    
    func yearNext(year: Date) -> DateInterval {
        let next: Date = self.date(byAdding: .year, value: 1, to: year) ?? year;
        let start = startOfYear(year: next);
        let end = endOfYear(year: next);
        return DateInterval(start: CalendarUtils.dayDate(for: start) , end: CalendarUtils.dayDate(for: end));
    }
    
    // MARK: - Compare
    
    func isSame(in cmponent: Calendar.Component, date: Date, to: Date) -> Bool {
        return component(cmponent, from: date) == component(cmponent, from: to);
    }
    
    func isSame(_ components: Set<Calendar.Component>, from start: Date, to end: Date) -> Bool {
        let dateComponents: DateComponents = self.dateComponents(components, from: start, to: end)
        for component in components {
            if dateComponents.value(for: component) != 0 { return false}
        }
        return true
    }
}
