//
//  FileBrowser+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/8/18.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import FileBrowser

extension FileBrowser {
    static var homePath: URL = { URL(fileURLWithPath: NSHomeDirectory(), isDirectory: true) }()
    static var documentPath: URL = {  homePath.appendingPathComponent("Documents", isDirectory: true)  }()
    static var inboxPath: URL = {  documentPath.appendingPathComponent("Inbox", isDirectory: true) }()
    static var downloadPath: URL = { return documentPath.appendingPathComponent("Download", isDirectory: true) }()
    static var loggerPath: URL = { return documentPath.appendingPathComponent("Logger", isDirectory: true) }()
    static var bundlePath: URL = { return Bundle.main.bundleURL }()

    
    @discardableResult
    fileprivate static func browser(with path: URL? = nil, allowEditing: Bool = false, showCancelButton: Bool = true) -> FileBrowser{
        let fileBrowser = FileBrowser(initialPath: path, allowEditing: allowEditing, showCancelButton: showCancelButton)
        fileBrowser.modalPresentationStyle = .fullScreen
        fileBrowser.modalTransitionStyle = .coverVertical
        fileBrowser.navigationBar.isTranslucent = false;
        Helper.currentVc?.present(fileBrowser, animated: true, completion: nil)
        return fileBrowser
    }
    
    @discardableResult
    static func docmentBrower(allowEditing: Bool = true) -> FileBrowser {
        return browser(with: documentPath, allowEditing: allowEditing)
    }
    
    @discardableResult
    static func inboxBrower(allowEditing: Bool = false) -> FileBrowser {
        return browser(with: inboxPath, allowEditing: allowEditing)
    }
    
    @discardableResult
    static func loggerBrower(allowEditing: Bool = false) -> FileBrowser {
        return browser(with: loggerPath, allowEditing: allowEditing)
    }
    
    @discardableResult
    static func bundleBrower(allowEditing: Bool = false) -> FileBrowser {
        return browser(with: bundlePath, allowEditing: allowEditing)
    }
    
    @discardableResult
    static func csvBrower() -> FileBrowser {
        return browser(with: CSVHelper.directoryURL, allowEditing: true)
    }
}

/// AppDelegate - UIDocumentInteractionControllerDelegate
extension AppDelegate : UIDocumentInteractionControllerDelegate {
    
    /// UIApplication
    func application(_ app: UIApplication, open url: URL, options: [UIApplication.OpenURLOptionsKey : Any] = [:]) -> Bool {
        UILog.d("url. \(url.absoluteString)")
        UILog.d("options. \(options)")
        if url.scheme == "file" {
            if let fileBrower = Helper.currentVc?.navigationController as? FileBrowser {
                fileBrower.dismiss(animated: false) {[unowned self] in self.toFileBrowser() }
            } else {
                toFileBrowser()
            }
        } else {
            toFileInteraction(url)
        }
        return true
    }
    
    func application(_ application: UIApplication, performActionFor shortcutItem: UIApplicationShortcutItem, completionHandler: @escaping (Bool) -> Void) {
        if shortcutItem.type == "file" { toFileBrowser() }
    }
    
    /// UIDocumentInteractionControllerDelegate
    func documentInteractionControllerViewControllerForPreview(_ controller: UIDocumentInteractionController) -> UIViewController {
        return Helper.currentVc!
    }
    
    func toFileInteraction(_ url: URL) {
        let docVc = UIDocumentInteractionController(url: url)
        docVc.delegate = self
        docVc.presentPreview(animated: true)
    }
    
    func quickActions() {
        let file = UIMutableApplicationShortcutItem(type: "file", localizedTitle: "Firmware")
        UIApplication.shared.shortcutItems = [file]
    }
    func toFileBrowser() {
        FileBrowser.inboxBrower(allowEditing: true)
    }
}
