//
//  Reactive+MJRefreshComponent.swift
//  cttoll
//
//  Created by Mac on 2020/4/7.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift
import RxCocoa
import MJRefresh

/// 对MJRefreshComponent增加rx扩展
extension Reactive where Base: MJRefreshComponent {
     
    //正在刷新事件
    var refreshing: ControlEvent<Void> {
        let source: Observable<Void> = Observable.create {
            [weak control = self.base] observer  in
            if let asControl = control {
                asControl.refreshingBlock = {
                    observer.on(.next(()))
                }
            }
            return Disposables.create()
        }
        return ControlEvent(events: source)
    }
     
    //停止刷新Binder观察者
    var endRefreshing: Binder<Bool> {
        return Binder(base) { refresh, isEnd in
            if isEnd {
                refresh.endRefreshing()
            }
        }
    }
}
