//
//  String+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/10/30.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import UIKit

extension String {
    private func boundingRect(with constrainedSize: CGSize, font: UIFont, lineSpacing: CGFloat? = nil) -> CGSize {
        let attritube = NSMutableAttributedString(string: self)
        let range = NSRange(location: 0, length: attritube.length)
        attritube.addAttributes([NSAttributedString.Key.font: font], range: range)
        if let currentLineSpacing = lineSpacing {
            let paragraphStyle = NSMutableParagraphStyle()
            paragraphStyle.lineSpacing = currentLineSpacing
            paragraphStyle.lineBreakMode = .byCharWrapping
            attritube.addAttribute(NSAttributedString.Key.paragraphStyle, value: paragraphStyle, range: range)
        }
        let rect = attritube.boundingRect(with: constrainedSize, options: [.usesLineFragmentOrigin, .usesFontLeading], context: nil)
        var size = rect.size
        
        if let currentLineSpacing = lineSpacing {
            // 文本的高度减去字体高度小于等于行间距，判断为当前只有1行
            let spacing = size.height - font.lineHeight
            if spacing <= currentLineSpacing && spacing > 0 {
                size = CGSize(width: size.width, height: font.lineHeight)
            }
        }
        return size
    }
    
    private func boundingRect(with constrainedSize: CGSize, font: UIFont, lineSpacing: CGFloat? = nil, lines: Int) -> CGSize {
        if lines < 0 { return .zero }
        let size = boundingRect(with: constrainedSize, font: font, lineSpacing: lineSpacing)
        if lines == 0 { return size }

        let currentLineSpacing = (lineSpacing == nil) ? (font.lineHeight - font.pointSize) : lineSpacing!
        let maximumHeight = font.lineHeight*CGFloat(lines) + currentLineSpacing*CGFloat(lines - 1)
        if size.height >= maximumHeight {
            return CGSize(width: size.width, height: maximumHeight)
        }
        return size
    }
    
    private func sizeForFont(with font: UIFont, constrainedSize: CGSize = CGSize(width: CGFloat.greatestFiniteMagnitude, height: CGFloat.greatestFiniteMagnitude), lineSpacing: CGFloat? = nil, lines: Int = Int.max) -> CGSize{
        let size = boundingRect(with: constrainedSize, font: font, lineSpacing: lineSpacing, lines: lines)
        return size
    }

    func widthForFont(font: UIFont?) -> CGFloat {
        let size = sizeForFont(with: font ?? .customFont(ofSize: 15), lines: 0)
        return size.width;
    }

    func heightForFont(font: UIFont?, width: CGFloat, lineSpacing: CGFloat? = nil) -> CGFloat {
        let size = sizeForFont(with: font ?? .customFont(ofSize: 15),
                               constrainedSize: CGSize(width: width, height: CGFloat.greatestFiniteMagnitude),
                               lineSpacing: lineSpacing)
        return size.height;
    }
}
