//
//  UIColor+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/9/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

extension UIColor {
    
    /// rgbValue -> UIColor
    convenience init(rgb value: UInt32, alpha: CGFloat = 1) {
        let red     = CGFloat((value & 0xFF0000) >> 16)/255.0
        let green   = CGFloat((value & 0xFF00) >> 8)/255.0
        let blue    = CGFloat((value & 0xFF) >> 0)/255.0
        self.init(red: red, green: green, blue: blue, alpha: alpha)
    }
    
    /// Hex String -> UIColor
    convenience init(hexString: String, alpha: CGFloat = 1) {
        let hexString = hexString.trimmingCharacters(in: .whitespacesAndNewlines)
        let scanner = Scanner(string: hexString)
        if hexString.hasPrefix("#") {
            scanner.scanLocation = 1
        }
        var color: UInt32 = 0
        scanner.scanHexInt32(&color)
        self.init(rgb: color, alpha: alpha)
    }
     
    /// UIColor -> Hex String
    var hexString: String? {
        var red: CGFloat = 0
        var green: CGFloat = 0
        var blue: CGFloat = 0
        var alpha: CGFloat = 0
        let multiplier = CGFloat(255.999999)
        guard self.getRed(&red, green: &green, blue: &blue, alpha: &alpha) else { return nil }
        if alpha == 1.0 {
            return String( format: "#%02lX%02lX%02lX", Int(red * multiplier), Int(green * multiplier), Int(blue * multiplier) )
        } else {
            return String(format: "#%02lX%02lX%02lX%02lX", Int(red * multiplier), Int(green * multiplier), Int(blue * multiplier), Int(alpha * multiplier) )
        }
    }
    
    /// iOS 13 暗黑模式颜色适配
    static func darkMode(_ darkColor: UIColor, _ defaultColor:UIColor) -> UIColor {
        if #available(iOS 13.0, *) {
            let colorDynamic = UIColor.init { (traitCollection) -> UIColor in
                if (traitCollection.userInterfaceStyle == .dark) {
                    return darkColor
                } else {
                    return defaultColor
                }
            }
            return colorDynamic
        }
        return defaultColor
    }
    
    //获取反色
    func invertColor() -> UIColor {
        var r:CGFloat = 0, g:CGFloat = 0, b:CGFloat = 0
        self.getRed(&r, green: &g, blue: &b, alpha: nil)
        return UIColor(red:1.0-r, green: 1.0-g, blue: 1.0-b, alpha: 1)
    }
}
