//
//  UIDevice+Extension.swift
//  cttoll
//
//  Created by Mac on 2020/3/28.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import UIKit

extension UIDevice {
    
    static let simulator: Bool = {
        #if targetEnvironment(simulator)
            return true
        #else
            return false
        #endif
    } ()
    
    static let idiom : UIUserInterfaceIdiom = { return UIDevice.current.userInterfaceIdiom }()
    
    static let inch_3_5 : Bool = { return equalSize(640, 960) }()
    
    static let inch_4 : Bool =  { return equalSize(640, 1136) }()

    static let inch_4_7 : Bool = { return equalSize(750, 1334) }()

    static let inch_5_5 : Bool = { return equalSize(1242, 2208) || equalSize(1125, 2001) }()

    static let inch_5_8 : Bool = { return equalSize(1125, 2436) }()

    static let inch_6_1 : Bool = { return equalSize(828, 1792) || equalSize(750, 1624) }()

    static let inch_6_5 : Bool = { return equalSize(1242, 2688) }()

    static let topLayoutGuide: CGFloat = {
        if inch_5_8 || inch_6_1 || inch_6_5 { return 24+20 }
        return 20
    }()
    
    static let naviHeight: CGFloat = {
        return 44
    }()
    
    static let bottomLayoutGuide: CGFloat = {
        if inch_5_8 || inch_6_1 || inch_6_5 { return 34 }
        return 0
    }()
    
    static let naviLayoutGuide: CGFloat = {
        return topLayoutGuide + naviHeight
    }()
       
    public class func equalSize(_ width: Int, _ height: Int) -> Bool {
        guard let mode = UIScreen.main.currentMode else { return false}
        if mode.size.equalTo(CGSize(width: width, height: height)) { return true }
        return false
    }
    
    
    static let scrBounds = UIScreen.main.bounds
    static let scrWidth = scrBounds.size.width
    static let scrHeight = scrBounds.size.height
}

///: keyChain cache
extension UIDevice {
    private static func keyChainIdentifier(identifier:String) -> [CFString : Any] {
        return [kSecClass:kSecClassGenericPassword,
                kSecAttrService:identifier,
                kSecAttrAccount:identifier,
                kSecAttrAccessible:kSecAttrAccessibleAfterFirstUnlock]
    }
    
    /**
     保存数据
     - parameter data: 要存储的数据
     - parameter identifier: 存储数据的标示
     - returns 成功/失败
     */
    @discardableResult
    private static func keyChainSaveData(data:Any, identifier:String) -> Bool {
        //存储数据的条件
        var saveQueryInfo = keyChainIdentifier(identifier: identifier)
        //删除旧的数据
        SecItemDelete((saveQueryInfo as CFDictionary))
        //设置新的数据
        saveQueryInfo[kSecValueData] = NSKeyedArchiver.archivedData(withRootObject: data)
        //添加数据
        let saveState = SecItemAdd((saveQueryInfo as CFDictionary), nil)
        // 判断是否存储成功
        if saveState == errSecSuccess {
            return true
        }
        return false
    }
    
    /**
     读取数据
     - parameter identifier: 存储数据的标示
     */
    private static func keyChainReadData(identifier:String) -> String? {
        //通过标记获取数据查询条件
        var readQueryInfo:[CFString : Any] = keyChainIdentifier(identifier: identifier)
        // 设置搜索条件：这是获取数据的时，必须提供的两个属性
        // 查询结果返回到 kSecValueData
        readQueryInfo[kSecReturnData] = kCFBooleanTrue
        // 只返回搜索到的第一条数据
        readQueryInfo[kSecMatchLimit] = kSecMatchLimitOne
        
        // 创建一个数据对象
        var extractedData: AnyObject?
        // 通过条件查询数据
        SecItemCopyMatching(readQueryInfo as CFDictionary, &extractedData)
        
        if extractedData == nil {
            return nil
        }
        let unarchiverData = try? NSKeyedUnarchiver.unarchiveTopLevelObjectWithData(extractedData as! Data)
        if unarchiverData is String {
            return (unarchiverData as!String)
        }
        return nil
    }
    
    /**
     更新数据
     - parameter data: 要更新的数据
     - parameter identifier: 数据存储时的标示
          - returns 成功/失败
     */
    private static func keyChainUpdata(data:Any, identifier:String) -> Bool {
        // 通过标记获取数据更新的条件
        let updataQueryInfo = keyChainIdentifier(identifier: identifier)
        // 创建更新数据字典
        let updataInfo:[CFString : Any] = [kSecValueData:NSKeyedArchiver.archivedData(withRootObject: data)]
        // 获取存储的状态
        let updataStatus = SecItemUpdate(updataQueryInfo as CFDictionary, updataInfo as CFDictionary)
        // 判断是否存储成功
        if updataStatus == errSecSuccess {
            return true
        }
        return false
    }
    
    /**
     删除数据
     - parameter identifier: 存储数据的标示
     */
    static func keyChainDelete(identifier:String) {
        //获取删除数据的查询条件
        let deleteQueryInfo:[CFString : Any] = keyChainIdentifier(identifier: identifier)
        SecItemDelete(deleteQueryInfo as CFDictionary)
    }
    
    /**
     uuid 方法
     - key: bundleId
     */
    static func udidString(bundId: String = AppUtils.shared.bundleId) -> String {
        if let udid = keyChainReadData(identifier: bundId){ return udid }
        let uuid = AppUtils.shared.uuid;
        keyChainSaveData(data: uuid, identifier: bundId)
        return uuid;
    }
}
