//
//  UIFont+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/6/3.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

extension UIFont {
    
    open class func customFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: "PingFangSC-Regular", size: fontSize)!
    }

    open class func mediumCustomFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: "PingFangSC-Medium", size: fontSize)!

    }
    
    open class func boldCustomFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: "PingFangSC-Semibold", size: fontSize)!
    }
    
    open class func lightCustomFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: "PingFangSC-Light", size: fontSize)!
    }
    
    open class func thinCustomFont(ofSize fontSize: CGFloat) -> UIFont {
        return UIFont(name: "PingFangSC-Thin", size: fontSize)!
    }
    
    
    open class func showAllFonts() {
        let familyNames = UIFont.familyNames
        for familyName in familyNames {
            let fontNames = UIFont.fontNames(forFamilyName: familyName as String)
            for fontName in fontNames {
                UILog.v("字体font名称：\(fontName)")
            }
        }
    }
    
    func size(with str: String, limitWidth: CGFloat = UIDevice.scrWidth, limitHeight: CGFloat = CGFloat(Int.max)) -> CGSize {
        let option = NSStringDrawingOptions.usesLineFragmentOrigin
        let attributes = [NSAttributedString.Key.font: self]
        let rect: CGRect = str.boundingRect(with: CGSize(width: limitWidth, height: limitHeight), options: option, attributes: attributes, context: nil)
        print("sze:\(rect.size)")
        return rect.size
        
    }
}
