//
//  UIImage+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/7/22.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
 
extension UIImage {
    
    /// 重设图片大小
    func reSizeImage(_ reSize:CGSize)->UIImage {
        //UIGraphicsBeginImageContext(reSize);
        UIGraphicsBeginImageContextWithOptions(reSize,false,UIScreen.main.scale);
        self.draw(in: CGRect(x: 0, y: 0, width: reSize.width, height: reSize.height));
        let reSizeImage: UIImage = UIGraphicsGetImageFromCurrentImageContext()!;
        UIGraphicsEndImageContext();
        return reSizeImage;
    }
     
    /// 等比率缩放
    func scaleImage(_ scaleSize:CGFloat)->UIImage {
        let reSize = CGSize(width: self.size.width * scaleSize, height: self.size.height * scaleSize)
        return reSizeImage(reSize)
    }
    
    /// 根据颜色生成指定size的image对象
    static func image(_ color: UIColor, _ size: CGSize) -> UIImage? {
        UIGraphicsBeginImageContextWithOptions(size, false, 0.0);
        let ctx = UIGraphicsGetCurrentContext();
        ctx?.setFillColor(color.cgColor);
        ctx?.fill(CGRect(origin: CGPoint(x: 0, y: 0), size: size));
        let image = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        return image;
    }
    
    var noir: UIImage? {
        let context = CIContext(options: nil)
        guard let currentFilter = CIFilter(name: "CIPhotoEffectNoir") else { return nil }
        currentFilter.setValue(CIImage(image: self), forKey: kCIInputImageKey)
        if let output = currentFilter.outputImage,
            let cgImage = context.createCGImage(output, from: output.extent) {
            return UIImage(cgImage: cgImage, scale: scale, orientation: imageOrientation)
        }
        return nil
    }
    
    @available(iOS 10, *)
    func grayImage() -> UIImage? {
        let imageRef:CGImage = self.cgImage!
        let width:Int = imageRef.width
        let height:Int = imageRef.height
        // 创建灰度色彩空间对象，各种设备对待颜色的方式都不一样，颜色必须有一个相关的色彩空间
        let colorSpace: CGColorSpace = CGColorSpaceCreateDeviceGray()
        // iOS9 只能为alphaOnly | anphaNone
        let bitmapInfo = CGBitmapInfo(rawValue: CGImageAlphaInfo.premultipliedLast.rawValue);
        // 参数data指向渲染的绘制内存的地址，bitsOerComponent表示内存中像素的每个组件的位数,bytesPerRow表示每一行在内存中占的比特数，space表示使用的颜色空间，bitmapInfo表示是否包含alpha通道
        let context: CGContext = CGContext(data: nil, width: width, height: height, bitsPerComponent: 8, bytesPerRow: 0, space: colorSpace, bitmapInfo: bitmapInfo.rawValue)!

        let rect:CGRect = CGRect.init(x: 0, y: 0, width: width, height: height)
        context.draw(imageRef, in: rect)
        let outPutImage: CGImage = context.makeImage()!

        let newImage:UIImage = UIImage.init(cgImage: outPutImage, scale: self.scale, orientation: self.imageOrientation)
        return newImage;
    }
    
    /// iOS 13 暗黑模式颜色适配
    static func darkMode(_ darkImage: UIImage?, _ defaultImage: UIImage?) -> UIImage? {
        if #available(iOS 13.0, *) {
            if UITraitCollection.current.userInterfaceStyle == .dark {
                 return darkImage
           } else {
                return defaultImage
           }
        }
        return defaultImage
    }
    
    func dark() -> UIImage?{
        guard let imageCG = self.cgImage else {
            return nil
        }
        let width = imageCG.width
        let height = imageCG.height
        let colorSpace = CGColorSpaceCreateDeviceRGB()
        // 申请内存空间
        let pixels = UnsafeMutablePointer<UInt32>.allocate(capacity: width * height )
        //UInt32在计算机中所占的字节
        let uint32Size = MemoryLayout<UInt32>.size
        let context = CGContext.init(data: pixels,
                                     width: width,
                                     height: height,
                                     bitsPerComponent: 8,
                                     bytesPerRow: uint32Size * width,
                                     space: colorSpace,
                                     bitmapInfo: CGBitmapInfo.byteOrder32Little.rawValue | CGImageAlphaInfo.premultipliedLast.rawValue)

        context?.draw(imageCG, in: CGRect(x: 0, y: 0, width: width, height: height))
        // let voidPtr = UnsafeMutableRawPointer(pixels)
        // let bytePtr = voidPtr.assumingMemoryBound(to: UInt8.self)
        let bytePtr = pixels.withMemoryRebound(to: UInt8.self, capacity: width * height * 4, { btPtr in
            return btPtr
        })
        for y in 0 ..< height {
            for x in 0 ..< width {
                let rgb = bytePtr.advanced(by: (y * width + x) * 4)
                // argb 所在位置 alpha 0, blue  1, green 2, red 3
                let gray = UInt8(0.3 * (Double(rgb[3])+Double(rgb[2])+Double(rgb[1])))
                rgb[3] = gray
                rgb[2] = gray
                rgb[1] = gray
                rgb[0] = max(rgb[0], 200)
            }
        }
        guard let image = context?.makeImage() else {
            pixels.deallocate();
            return nil
        }
        pixels.deallocate();
        return UIImage(cgImage: image, scale: self.scale, orientation: self.imageOrientation)
    }
    
    func invert() -> UIImage? {
        guard let imageCG = self.cgImage else {
            return nil
        }
        let width = imageCG.width
        let height = imageCG.height
        let colorSpace = CGColorSpaceCreateDeviceRGB()
        // 申请内存空间
        let pixels = UnsafeMutablePointer<UInt32>.allocate(capacity: width * height )
        //UInt32在计算机中所占的字节
        let uint32Size = MemoryLayout<UInt32>.size
        let context = CGContext.init(data: pixels,
                                     width: width,
                                     height: height,
                                     bitsPerComponent: 8,
                                     bytesPerRow: uint32Size * width,
                                     space: colorSpace,
                                     bitmapInfo: CGBitmapInfo.byteOrder32Little.rawValue | CGImageAlphaInfo.premultipliedLast.rawValue)

        context?.draw(imageCG, in: CGRect(x: 0, y: 0, width: width, height: height))
        // let voidPtr = UnsafeMutableRawPointer(pixels)
        // let bytePtr = voidPtr.assumingMemoryBound(to: UInt8.self)
        let bytePtr = pixels.withMemoryRebound(to: UInt8.self, capacity: width * height * 4, { btPtr in
            return btPtr
        })
        for y in 0 ..< height {
            for x in 0 ..< width {
                // argb 所在位置 alpha 0, blue  1, green 2, red 3
                let rgb = bytePtr.advanced(by: (y * width + x) * 4)
                rgb[3] = 255-rgb[3]
                rgb[2] = 255-rgb[2]
                rgb[1] = 255-rgb[1]
                
                let pointer = pixels.advanced(by: y * width + x)
                if pointer.pointee < 0xFEFEFE00 {
                    rgb[3] += 20
                    rgb[2] += 20
                    rgb[1] += 20
                }
            }
        }
        guard let image = context?.makeImage() else {
            pixels.deallocate();
            return nil
        }
        pixels.deallocate();
        return UIImage(cgImage: image, scale: self.scale, orientation: self.imageOrientation)
    }
    
}
