//
//  UIView+Extension.swift
//  CTFit
//
//  Created by Mac on 2020/6/2.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

extension UIView {
    
    /// 圆角幅度
    var borderCorner :CGFloat {
        get {
            return self.layer.cornerRadius;
        }
        set {
            self.layer.cornerRadius = newValue;
            self.layer.masksToBounds = true;
            self.setNeedsDisplay();
        }
    }
    
    /// 剪切圆
    func circle(border: CGFloat, borderColor: UIColor) {
        self.layer.cornerRadius = self.bounds.size.width / 2;
        self.layer.masksToBounds = true;
        
        if border > 0 {
            self.layer.borderWidth = border;
            self.layer.borderColor = borderColor.cgColor;
            self.isUserInteractionEnabled = true;
        }
    }
    
    /// 转化为图片
    func imageFromView() -> UIImage? {
        let size = self.bounds.size;
        UIGraphicsBeginImageContext(size)
        //UIGraphicsBeginImageContextWithOptions(size, false, UIScreen.main.scale);
        self.layer.render(in: UIGraphicsGetCurrentContext()!);
        let image = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        return image;
    }
    
}

// MARK: - Layout

extension UIView {
    
    var x :CGFloat {
        get { return self.frame.origin.x }
        set { self.frame.origin.x = newValue }
    }
    
    var y :CGFloat {
        get { return self.frame.origin.y }
        set { self.frame.origin.y = newValue }
    }
    
    var width :CGFloat {
        get { return self.frame.size.width }
        set { self.frame.size.width = newValue }
    }
    
    var height :CGFloat {
        get { return self.frame.size.height }
        set { self.frame.size.height = newValue }
    }
    
    var origin :CGPoint {
        get { return self.frame.origin }
        set { self.frame.origin = newValue }
    }
    
    func originOffset(x: CGFloat, y: CGFloat) {
        self.frame = CGRect(x: self.frame.origin.x + x, y: self.frame.origin.y + y, width: width, height: height)
    }
    
    var size :CGSize {
        get { return self.frame.size }
        set { self.frame.size = newValue }
    }
    
    func sizeOffset(width: CGFloat, height: CGFloat) {
        self.frame = CGRect(x: x, y: y, width: self.width + width, height: self.height + height)
    }
    
    var centerX :CGFloat {
        get { return self.center.x }
        set { self.center.x = newValue }
    }
    
    var centerY :CGFloat {
        get { return self.center.y }
        set { self.center.y = newValue }
    }
}

// MARK: - 使用模式
extension UIView {
    
    public func userDarkMode() {
        if #available(iOS 13.0, *) {
            overrideUserInterfaceStyle = .dark
        }
    }
    
    public func userLightMode() {
        if #available(iOS 13.0, *) {
            overrideUserInterfaceStyle = .light
        }
    }
}

// MARK: - 添加关联属性
extension UIView {
    // 嵌套结构体
    private struct AssociatedKeys {
        static var displayKey = "displayKey"
        static var displayNameKey = "displayNameKey"
    }
    
    // Bool 类型
    var display: Bool {
        get {
            return objc_getAssociatedObject(self, &AssociatedKeys.displayKey) as! Bool
        }
        set {
            objc_setAssociatedObject(self, &AssociatedKeys.displayKey, newValue, objc_AssociationPolicy.OBJC_ASSOCIATION_RETAIN_NONATOMIC)
        }
    }
    
    // String 类型
    var displayName: String? {
        get {
            return objc_getAssociatedObject(self, &AssociatedKeys.displayNameKey) as? String
        }
        set {
            objc_setAssociatedObject(self, &AssociatedKeys.displayNameKey, newValue, objc_AssociationPolicy.OBJC_ASSOCIATION_COPY_NONATOMIC)
        }
    }
}

// MARk: - 设置阴影,  子视图切部分圆角
extension UIView {
    func clipsTopCornerRadius(_ radius: CGFloat) {
        let maskPath: UIBezierPath = UIBezierPath(roundedRect: bounds, byRoundingCorners: [.topLeft, .topRight], cornerRadii: CGSize(width: radius, height: radius))
        let maskLayer: CAShapeLayer = CAShapeLayer()
        maskLayer.frame = bounds
        maskLayer.path = maskPath.cgPath
        layer.mask = maskLayer
    }

    func clipsCornerRadius(_ radius: CGFloat,  corners : UIRectCorner) {
        let maskPath: UIBezierPath = UIBezierPath(roundedRect: bounds, byRoundingCorners: corners, cornerRadii: CGSize(width: radius, height: radius))
        let maskLayer: CAShapeLayer = CAShapeLayer()
        maskLayer.frame = bounds
        maskLayer.path = maskPath.cgPath
        layer.mask = maskLayer
    }
}

