//
//  Helper.swift
//  CTFit
//
//  Created by Mac on 2020/5/30.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit

class Helper: NSObject {
    
    static var keyWindow: UIWindow? { UIApplication.shared.keyWindow }
    
    /// 根控制器
    static var rootVc: UIViewController? {  UIApplication.shared.keyWindow?.rootViewController }
    
    /// 当前显示控制器
    static var currentVc: UIViewController? {
        guard var resultVc = rootVc else { return nil }
        while (true) {
            if (resultVc.isKind(of: UITabBarController.self)) {
                resultVc = (resultVc as! UITabBarController).selectedViewController!
            } else if (resultVc.isKind(of: UINavigationController.self)) {
                resultVc = (resultVc as! UINavigationController).visibleViewController!
            } else if ((resultVc.presentedViewController) != nil) {
                resultVc =  resultVc.presentedViewController!
            } else {
                break;
            }
        }
        return resultVc;
    }
    
    /// 当前显示控制器View
    static var currentControllerView: UIView? {
        guard let curVc = currentVc else { return nil }
        return curVc.view;
    }
    
    /// view 所在控制器
    static func viewController(with view: UIView) -> UIViewController? {
        var nextResponder: UIResponder? = view
        repeat {
            nextResponder = nextResponder?.next
            if let viewController = nextResponder as? UIViewController {
                return viewController
            }
        } while nextResponder != nil
        
        return nil
    }
    
    static func openPermissionSetting() {
        guard let url = URL(string: UIApplication.openSettingsURLString) else { return }
        guard UIApplication.shared.canOpenURL(url) else { return }
        if #available(iOS 10.0, *) {
            UIApplication.shared.open(url, options: [:], completionHandler: nil)
        } else {
            UIApplication.shared.openURL(url)
        }
    }
    
    static func openURL(_ url: URL) {
        guard UIApplication.shared.canOpenURL(url) else { return }
        if #available(iOS 10.0, *) {
            UIApplication.shared.open(url, options: [:], completionHandler: nil)
        } else {
            UIApplication.shared.openURL(url)
        }
    }
}
