//
//  MigrationHelper.swift
//  CTFit
//
//  Created by Mac on 2020/12/23.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation

/// :  V2 -> V3 工程的迁移变化

class MigrationHelper {
    
    private static var documentPath: URL {
        return FileManager.default.urls(for: .documentDirectory, in: .userDomainMask)[0]
    }
    
    private static var logDirectoryPath: URL = { return documentPath.appendingPathComponent("Log", isDirectory: true) }()

    @discardableResult
    private static func delete(for url: URL) -> Bool {
        do {
            try FileManager.default.removeItem(at: url);
            return true
        } catch {
            return false
        }
    }
    
    private static func removeLogDirectory() {
        var directory: ObjCBool = ObjCBool(false)
        let exists = FileManager.default.fileExists(atPath: logDirectoryPath.path, isDirectory: &directory)
        /// 判断目录存在
        if exists && directory.boolValue{
            delete(for: logDirectoryPath)
        }
    }
    
    private static func removeOldCSV() {
        let fileManager = FileManager.default
        let properties: [URLResourceKey] = [.fileSizeKey, .contentModificationDateKey, .nameKey];
        let directoryOptions: FileManager.DirectoryEnumerationOptions = .skipsSubdirectoryDescendants;
        let urlItems = try? fileManager.contentsOfDirectory(at: documentPath, includingPropertiesForKeys: properties, options: directoryOptions)
        if let hasUrlItems = urlItems {
            for url in hasUrlItems {
                if url.pathExtension == "csv" { delete(for: url) }
            }
        }
    }
    
    private static func removeCoreData() {
        let fileManager = FileManager.default
        let properties: [URLResourceKey] = [.fileSizeKey, .contentModificationDateKey, .nameKey];
        let directoryOptions: FileManager.DirectoryEnumerationOptions = .skipsSubdirectoryDescendants;
        let urlItems = try? fileManager.contentsOfDirectory(at: documentPath, includingPropertiesForKeys: properties, options: directoryOptions)
        if let hasUrlItems = urlItems {
            for url in hasUrlItems {
                if url.lastPathComponent.hasPrefix("CTFit.db") { delete(for: url) }
            }
        }
    }
    
    static func setup() {
        DispatchQueue.global().async {
            removeLogDirectory()
            removeOldCSV()
            CoreDataManager.migration()
            removeCoreData()
        }
    }
}
