//
//  AudioManager.swift
//  CTFit
//
//  Created by Mac on 2019/6/21.
//  Copyright © 2019 shirajo. All rights reserved.
//

import UIKit
import AudioToolbox

// MARK: - 系统声音

@objc class AudioManager: NSObject {
    static let shared = AudioManager();
    
    /// 滚动咔咔声
    fileprivate var kTockSoundId: UInt32 = 0;
    fileprivate let kTockSoundUrl: URL = URL(fileURLWithPath: "/System/Library/Audio/UISounds/Tock.caf");
    
    /// 查找手机
    fileprivate var notifyTimer: Timer?
    fileprivate var kRingtoneSoundId: UInt32 = 0
    fileprivate let kRingtoneSoundUrl = URL(fileURLWithPath: "/Library/Ringtones/Marimba.m4r") // 系统铃声

    ///  播放查找手机声音：Marimba + vibrate
    fileprivate func notifyToFindPhone(_ duration: TimeInterval) {
        if kRingtoneSoundId == 0 { AudioServicesCreateSystemSoundID(kRingtoneSoundUrl as CFURL, &kRingtoneSoundId); }
        AudioServicesAddSystemSoundCompletion(kSystemSoundID_Vibrate, nil, nil, { (_, _) in
            AudioServicesPlaySystemSound(kSystemSoundID_Vibrate);
        }, nil)
        AudioServicesAddSystemSoundCompletion(kRingtoneSoundId, nil, nil, { (soundId, _) in
            AudioServicesPlaySystemSound(soundId);
        }, nil)
        
        AudioServicesPlaySystemSound(kRingtoneSoundId);
        AudioServicesPlaySystemSound(kSystemSoundID_Vibrate);
        DispatchQueue.main.asyncAfter(deadline: .now() + duration) {
            self.stopNotify()
        }
    }
    
    fileprivate func stopNotify() {
        AudioServicesRemoveSystemSoundCompletion(kRingtoneSoundId)
        AudioServicesRemoveSystemSoundCompletion(kSystemSoundID_Vibrate);
    }
    
    /// 振动
    fileprivate func vibrate() {
        AudioServicesPlaySystemSound(kSystemSoundID_Vibrate);
    }

    /// 查找手机
    fileprivate func onFindPhone() {
        DispatchQueue.main.async { /// 响铃10秒，震动10秒
            self.notifyToFindPhone(10);
        }
    }
    
    /// 滚动声
    public func playKaka() {
        guard ApplicationDatasource.sound else { return }
        if kTockSoundId == 0 { AudioServicesCreateSystemSoundID(kTockSoundUrl as CFURL, &kTockSoundId); }
        AudioServicesPlaySystemSound(kTockSoundId);
    }
}

import RxSwift
extension AudioManager {
    private static var mainScheduler = MainScheduler.instance
    private static var disposeBag = DisposeBag()
    private static func findePhone(for type: BDNotifyType.FindPhone) {
        switch type {
        case .on: shared.onFindPhone()
        case .off: shared.stopNotify()
        }
    }
    
    public static func observeFindPhone() {
        BandData.updatedOutput.observeOn(mainScheduler).subscribe(onNext: { (dataType) in
            guard case BDDataType.notify(let notifyType) = dataType,
                  case BDNotifyType.findPhone(let type) = notifyType  else { return }
            findePhone(for: type)
        }).disposed(by: disposeBag)
    }
}

