//
//  SpeechUtteranceManager.swift
//  CTFit
//
//  Created by Mac on 2020/6/16.
//  Copyright © 2020 shirajo. All rights reserved.
//

import AVFoundation

/// 语音播报 - 支持后台

class SpeechUtteranceManager: NSObject {
    /// 单例管理语音播报 比较适用于多种类型语音播报管理
    private static let shared = SpeechUtteranceManager()
    
    private var synthesizer = AVSpeechSynthesizer()
    private var speechUtterance: AVSpeechUtterance?
    private var voiceType = AVSpeechSynthesisVoice(language: Locale.current.languageCode)

    private override init() {
        super.init()
        do {
            try AVAudioSession.sharedInstance().setCategory(.playback, options: .duckOthers)
        } catch {
            UILog.w(error.localizedDescription)
        }
        synthesizer.delegate = self
    }
    
    /// 自定义语音播报方法
    /// 此处只举例播报一个String的情况
    private func speechText(_ text: String) {
        if let _ = speechUtterance { synthesizer.stopSpeaking(at: .immediate) }
        
        do {
            try AVAudioSession.sharedInstance().setActive(true)
        } catch {
            print(error.localizedDescription)
        }
        
        speechUtterance = AVSpeechUtterance(string: text)
        speechUtterance?.voice = voiceType
        speechUtterance?.rate = 0.5
        synthesizer.speak(speechUtterance!)
    }
    
    static var text: String = "" {
        didSet {
            guard text.count>0 else { return }
            shared.voiceType = AVSpeechSynthesisVoice(language: Locale.current.languageCode)
            shared.speechText(text)
        }
    }
}


extension SpeechUtteranceManager: AVSpeechSynthesizerDelegate {
    func speechSynthesizer(_ synthesizer: AVSpeechSynthesizer, didFinish utterance: AVSpeechUtterance) {
        do {
            try AVAudioSession.sharedInstance().setActive(false, options: .notifyOthersOnDeactivation)
        } catch {
            UILog.w(error.localizedDescription)
        }
        speechUtterance = nil
    }
}

