//
//  SRDeviceOrientationHelper.swift
//  CTFit
//
//  Created by Mac on 2020/11/3.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import CoreMotion

class SRDeviceOrientationHelper {
    
    /// 推荐使用单例，因为应用程序应该只创建CMMotionManager类的单个实例
    static let shared = SRDeviceOrientationHelper()
    private let motionManager: CMMotionManager
    private let queue: OperationQueue
    typealias DeviceOrientationHandler = ((_ deviceOrientation: UIDeviceOrientation) -> Void)?
    private var deviceOrientationAction: DeviceOrientationHandler?
    
    public var currentDeviceOrientation: UIDeviceOrientation = .portrait
    /// Smallers的值使得它对检测方向变化非常敏感。[0, 1]
    
    private let motionLimit: Double = 0.6
    
    init() {
        motionManager = CMMotionManager()
        /// 指定以秒为单位的更新间隔，个人发现这个值提供了很好的用户体验
        motionManager.accelerometerUpdateInterval = 0.2
        queue = OperationQueue()
    }
    
    public func startDeviceOrientationNotifier(with handler: DeviceOrientationHandler) {
        self.deviceOrientationAction = handler
        
        /// 不建议使用主队列。创建新的操作队列并传递给startAccelerometerUpdatesToQueue。
        /// 在处理器中使用async调度U/I代码到主线程。
        motionManager.startAccelerometerUpdates(to: queue) { (data, error) in
            if let accelerometerData = data {
                var newDeviceOrientation: UIDeviceOrientation?
                
                if (accelerometerData.acceleration.x >= self.motionLimit) {
                    newDeviceOrientation = .landscapeRight
                }
                else if (accelerometerData.acceleration.x <= -self.motionLimit) {
                    newDeviceOrientation = .landscapeLeft
                }
                else if (accelerometerData.acceleration.y <= -self.motionLimit) {
                    newDeviceOrientation = .portrait
                }
                else if (accelerometerData.acceleration.y >= self.motionLimit) {
                    newDeviceOrientation = .portraitUpsideDown
                }
                else {
                    return
                }
                /// 仅当检测到不同的方向时，执行处理程序
                if let newDeviceOrientation = newDeviceOrientation, newDeviceOrientation != self.currentDeviceOrientation {
                    self.currentDeviceOrientation = newDeviceOrientation
                    if let deviceOrientationHandler = self.deviceOrientationAction {
                        DispatchQueue.main.async {
                            deviceOrientationHandler!(self.currentDeviceOrientation)
                        }
                    }
                }
            }
        }
    }
    
    public func stopDeviceOrientationNotifier() {
        motionManager.stopAccelerometerUpdates()
    }
    
    
}
