//
//  SRCropViewContainer.swift
//  CTFit
//
//  Created by Mac on 2020/11/17.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import Foundation
import UIKit
import AVFoundation
import Photos

class SRCropAreaView: UIView {
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        setupSubviews()
        // addGestrue()
    }
    
    ///: - View customer
    public lazy var zoomableView: SRCropZoomableView = {
        let view = SRCropZoomableView()
        // view.myDelegate = self
        return view
    } ()
    
    public lazy var grid: SRCropGridView = {
        let view = SRCropGridView()
        // view.alpha = 0
        return view
    } ()
        
    /// grid show
    public var isShown = true

    private func setupSubviews() {
        let items = [zoomableView, grid]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        zoomableView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
        grid.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    func setImage(_ image: UIImage) {
        DispatchQueue.main.asyncAfter(deadline: .now()+0.01) {
            self.zoomableView.setImage(image)
        }
    }
    
    func cropImage() -> UIImage? {
        return zoomableView.cropImage()
    }
}

// MARK: - ZoomableViewDelegate

extension SRCropAreaView: SRCropZoomableViewDelegate {
    public func srAssetZoomableViewDidLayoutSubviews(_ zoomableView: SRCropZoomableView) {
    }
    
    public func srAssetZoomableViewScrollViewDidZoom() {
        if isShown {
            UIView.animate(withDuration: 0.1) {
                self.grid.alpha = 1
            }
        }
    }
    public func srAssetZoomableViewScrollViewDidEndZooming() {
        UIView.animate(withDuration: 0.3) {
            self.grid.alpha = 0
        }
    }
}

// MARK: - Gesture recognizer Delegate
extension SRCropAreaView: UIGestureRecognizerDelegate {
    /// 按下手势
    private func addGestrue() {
        let touchDownGR = UILongPressGestureRecognizer(target: self, action: #selector(handleTouchDown))
        touchDownGR.minimumPressDuration = 0
        touchDownGR.delegate = self
        addGestureRecognizer(touchDownGR)
    }
    
    public func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldRecognizeSimultaneouslyWith
        otherGestureRecognizer: UIGestureRecognizer) -> Bool {
        return true
    }
    
    public func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        return !(touch.view is UIButton)
    }
    
    @objc
    private func handleTouchDown(sender: UILongPressGestureRecognizer) {
        switch sender.state {
        case .began:
            if isShown {
                UIView.animate(withDuration: 0.1) {
                    self.grid.alpha = 1
                }
            }
        case .ended:
            UIView.animate(withDuration: 0.3) {
                self.grid.alpha = 0
            }
        default: ()
        }
    }
}
