//
//  SRCropGridView.swift
//  CTFit
//
//  Created by Mac on 2020/11/16.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit

class SRCropGridView: UIView {
    
    convenience init() {
        self.init(frame: .zero)
        isUserInteractionEnabled = false
        setupSubviews()
    }
    
    private func setupSubviews() {
        let items = [separatorView, line1, line2, line3, line4]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        separatorView.snp.makeConstraints { (make) in
            make.center.equalToSuperview()
            make.width.equalToSuperview().multipliedBy(0.333)
            make.height.equalToSuperview().multipliedBy(0.333)
        }
        
        line1.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.top.equalTo(separatorView.snp.top)
        }
        
        line2.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalTo(separatorView.snp.bottom)
        }
        
        line3.snp.makeConstraints { (make) in
            make.top.bottom.equalToSuperview()
            make.width.equalTo(0.5)
            make.left.equalTo(separatorView.snp.left)
        }
        
        line4.snp.makeConstraints { (make) in
            make.top.bottom.equalToSuperview()
            make.width.equalTo(0.5)
            make.right.equalTo(separatorView.snp.right)
        }
    }
    
    private lazy var line1 = separatorLine()
    private lazy var line2 = separatorLine()
    private lazy var line3 = separatorLine()
    private lazy var line4 = separatorLine()
    private lazy var separatorView = UIView()
    private func separatorLine() -> UIView {
        let view = UIImageView()
        let color = UIColor.white
        view.backgroundColor = color
        view.layer.shadowColor = UIColor.black.cgColor
        view.layer.shadowOpacity = 1
        view.layer.shadowRadius = 2
        view.layer.shadowOffset = CGSize(width: 0, height: 0)
        return view
    }
}
