//
//  SRCropViewController.swift
//  CTFit
//
//  Created by Mac on 2020/11/9.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class SRCropViewController: BaseViewController, CustomView {
    
    typealias ViewClass = SRCropView
    
    required init(_ image: UIImage, _ ratio: Double, type: SRLibraryType = .portrait) {
        v = ViewClass(image: image, ratio: ratio, type: type)
        originalImage = image
        super.init()
        navigationItem.title = SRString.ImagePicker.crop.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = v
    }
    
    override var prefersStatusBarHidden: Bool {
        return false
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.dark
        onDidFinishCropping()
    }
    
    // MARK: - Field
    private let v: ViewClass
    private let originalImage: UIImage
    typealias DidFinishCropping = (_ image: UIImage) -> Void
    private var didFinishCropping: DidFinishCropping?    
}

extension SRCropViewController {
    
    func onDidFinishCropping(_ closure: @escaping DidFinishCropping) {
        didFinishCropping = closure
    }
    
    private func onDidFinishCropping() {
        customView.onDidFinishCropping { [weak self] (image) in
            guard let strong = self else { return }
            strong.didFinishCropping?(image)
        }
    }

    
    @discardableResult
    static func enter(_ image: UIImage, type: SRLibraryType = .portrait) -> SRCropViewController? {
        guard case let SRCropType.rectangle(ratio: ratio) = SRCropConfig.showsCrop else { return nil }
        guard let vc = Helper.currentVc else { return nil }
        let cropVc = SRCropViewController(image, ratio, type: type)
        vc.navigationController?.pushViewController(cropVc, animated: true)
        return cropVc
    }
}
