//
//  SRAlbumButton.swift
//  CTFit
//
//  Created by Mac on 2020/11/6.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class SRAlbumButton: UIControl {
    
    var text: String? { didSet { titleLabel.text = text } }
    
    ///: - Initialize
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        addSubviews()
    }
    
    
    // MARK: - View customer
    fileprivate func addSubviews() {
        [titleLabel, arrowImage].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        titleLabel.snp.makeConstraints { (make) in
            make.left.top.bottom.equalToSuperview()
            make.height.equalTo(36)
        }
        
        arrowImage.snp.makeConstraints { (make) in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(titleLabel.snp.right).offset(4)
        }
        
    }
        
    fileprivate lazy var titleLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.naviTitle)
        label.text = SRString.ImagePicker.album.locastr // "Gallery"  图库
        return label
    } ()
    
    fileprivate lazy var arrowImage: UIImageView = {
        let view = UIImageView(image: ImageRepo.Navi.down)
        view.contentMode = .scaleAspectFit
        view.tintColor = Colors.NavigationBar.foreground
        return view
    } ()
}

extension SRAlbumButton {
    
    private func onTouch(_ down: Bool) {
        var color = Colors.NavigationBar.foreground
        if down { color = color.withAlphaComponent(0.7)}
        titleLabel.textColor = color
        arrowImage.tintColor = color
    }
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        guard let touch = touches.first else { return }
        let location = touch.location(in: self)
        if self.bounds.contains(location) {
            onTouch(true)
            sendActions(for: .touchDown);
        }
    }
    
    override func touchesEnded(_ touches: Set<UITouch>, with event: UIEvent?) {
        guard let touch = touches.first else { return }
        let location = touch.location(in: self)
        onTouch(false)
        if self.bounds.contains(location) {
            sendActions(for: .touchUpInside);
        }
    }
    
    override func touchesCancelled(_ touches: Set<UITouch>, with event: UIEvent?) {
        onTouch(false)
    }
}
