//
//  File.swift
//  CTFit
//
//  Created by Mac on 2020/11/6.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Foundation

class SRAlbumCell: BaseTableViewCell {
    
    func load(with album: SRAlbum) {
        thumbnailView.image = album.thumbnail
        titleLabel.text = album.title
        numberLabel.text = "(\(album.numberOfItems))"
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        addSubviews()
    }
    
    ///: - View customer
    lazy var thumbnailView: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        view.backgroundColor = Colors.gray
        return view
    } ()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.title)
        label.textAlignment = .left
        return label
    } ()
    
    lazy var numberLabel: UILabel = {
        let label = UILabel(style: Stylesheet.Label.title)
        label.textColor = Colors.gray
        label.textAlignment = .left
        return label
    } ()
    
    private func addSubviews() {
        let items = [thumbnailView, titleLabel, numberLabel]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        thumbnailView.snp.makeConstraints { (make) in
            make.left.equalToSuperview().offset(10)
            make.top.equalToSuperview().offset(6)
            make.bottom.equalToSuperview().offset(-6)
            make.height.width.equalTo(58)
        }
        
        titleLabel.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.left.equalTo(thumbnailView.snp.right).offset(10)
        }
        
        numberLabel.snp.makeConstraints { (make) in
            make.centerY.equalToSuperview()
            make.left.equalTo(titleLabel.snp.right).offset(2)
        }
    }
    
}
