//
//  SRAlbumView.swift
//  CTFit
//
//  Created by Mac on 2020/11/6.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit

class SRAlbumView: UIView {
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    init() {
        super.init(frame: .zero)
        backgroundColor = Colors.Base.background
        addSubviews()
    }
    
    ///: - View customer
    
    private func addSubviews() {
        let items = [tableView, spinner]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        tableView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
        
        spinner.snp.makeConstraints { (make) in
            make.center.equalToSuperview()
        }
    }
    
    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .plain)
        tableView.estimatedRowHeight = 70
        tableView.estimatedSectionHeaderHeight = 0;
        tableView.estimatedSectionFooterHeight = 0;
        tableView.tableHeaderView = UIView()
        tableView.tableFooterView = UIView()
        tableView.tintColor = Colors.Cell.title
        tableView.backgroundColor = Colors.Cell.background
        tableView.separatorColor = Colors.Cell.separator
        tableView.clipsToBounds = true
        tableView.showsVerticalScrollIndicator = false
        tableView.showsHorizontalScrollIndicator = false
        tableView.separatorInset = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 0)
        return tableView
    }()

    lazy var spinner:  UIActivityIndicatorView = {
        let view = UIActivityIndicatorView(style: .whiteLarge)
        view.color = Colors.gray
        return view
    } ()
}
