//
//  SRAlbumViewController.swift
//  CTFit
//
//  Created by Mac on 2020/11/6.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Photos

class SRAlbumViewController: BaseViewController, CustomView {
    typealias ViewClass = SRAlbumView
    
    
    var didSelectAlbum: ((SRAlbum) -> Void)?
    var albums = [SRAlbum]()
    let albumsManager: SRAlbumsManager
    
    override func loadView() {
        super.loadView()
        view = ViewClass()
    }
    
    required init(_ albumsManager: SRAlbumsManager) {
        self.albumsManager = albumsManager
        super.init()
        navigationItem.title =  SRString.ImagePicker.album.locastr //"Photo Album"//"相簿"
    }
    
    override func initNavigationBar(){
        super.initNavigationBar()
        navigationItem.leftBarButtonItem = cancelBarItem()
    }

    
    override func viewDidLoad() {
        super.viewDidLoad()
        setUpTableView()
        fetchAlbumsInBackground()
    }
    
    func fetchAlbumsInBackground() {
        customView.spinner.startAnimating()
        DispatchQueue.global(qos: .userInitiated).async { [weak self] in
            guard let strong = self else { return }
            strong.albums = strong.albumsManager.fetchAlbums() 
            DispatchQueue.main.async {
                strong.customView.spinner.stopAnimating()
                strong.customView.tableView.isHidden = false
                strong.customView.tableView.reloadData()
            }
        }
    }
    
    @objc
    func close() {
        dismiss(animated: true, completion: nil)
    }
    
    func setUpTableView() {
        customView.tableView.isHidden = true
        customView.tableView.dataSource = self
        customView.tableView.delegate = self
        customView.tableView.rowHeight = UITableView.automaticDimension
        customView.tableView.register(SRAlbumCell.self, forCellReuseIdentifier: "SRAlbumCell")
    }
}

extension SRAlbumViewController: UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return albums.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let album = albums[indexPath.row]
        if let cell = tableView.dequeueReusableCell(withIdentifier: "SRAlbumCell", for: indexPath) as? SRAlbumCell {
            cell.load(with: album)
            return cell
        }
        return UITableViewCell()
    }
}

extension SRAlbumViewController: UITableViewDelegate {
    public func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        didSelectAlbum?(albums[indexPath.row])
    }
}
