//
//  SRLibraryConfig.swift
//  CTFit
//
//  Created by Mac on 2020/11/4.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Foundation
import Photos
import AVFoundation

struct SRLibraryConfig {
    
    /// 最大可选数量，默认 1
    public static var maxNumberOfItems: Int = 1
    
    /// 强制用户至少选择已定义的项目数量
    /// 大于 1， 将取消现场照片和视频模式
    public static var minNumberOfItems = 1
    
    /// 在集合视图中设置每行的项数，默认为 4
    public static var numberOfItemsInRow: Int = 4
    
    /// 多选择按钮的初始状态.
    public static var defaultMultipleSelection = false
    
    /// 在集合视图中设置项目之间的间距，默认为 1.0
    public static var spacingBetweenItems: CGFloat = 1.0
    
    /// 允许预选媒体项目
    public static var preselectedItems: [SRMediaItem]?
    
    /// 选择库中可用的媒体类型。默认为 “.photo”
    public static var mediaType: SRlibraryMediaType = .photo
    
    /// PHFetchOptions
    public static var options: PHFetchOptions? = nil

}

extension SRLibraryConfig {
    /// 选择视频压缩，默认为：AVAssetExportPresetHighestQuality
    public static var compression: String = AVAssetExportPresetHighestQuality
    
    /// 选择结果视频扩展，如果你修剪或压缩视频；默认为：mov
    public static var fileType: AVFileType = .mov

}

public enum SRlibraryMediaType {
    case photo
    case video
    case photoAndVideo
}
