//
//  SRLibraryView+ChangeObserver.swift
//  CTFit
//
//  Created by Mac on 2020/11/5.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Photos

extension SRLibraryView: PHPhotoLibraryChangeObserver {
    
    func registerForLibraryChanges() {
        PHPhotoLibrary.shared().register(self)
    }
    
    func unregisterForLibraryChanges() {
        PHPhotoLibrary.shared().unregisterChangeObserver(self)
    }
    
    func photoLibraryDidChange(_ changeInstance: PHChange) {
        DispatchQueue.main.async {
            let fetchResult = self.mediaManager.fetchResult!
            if let collectionChanges = changeInstance.changeDetails(for: fetchResult) {
                self.mediaManager.fetchResult = collectionChanges.fetchResultAfterChanges
                let collectionView = self.collectionView
                if !collectionChanges.hasIncrementalChanges || collectionChanges.hasMoves {
                    collectionView.reloadData()
                } else {
                    
                    collectionView.performBatchUpdates({
                        let removedIndexes = collectionChanges.removedIndexes
                        if (removedIndexes?.count ?? 0) != 0 {
                            collectionView.deleteItems(at: removedIndexes!.aapl_indexPathsFromIndexesWithSection(0))
                        }
                        let insertedIndexes = collectionChanges.insertedIndexes
                        if (insertedIndexes?.count ?? 0) != 0 {
                            collectionView.insertItems(at: insertedIndexes!.aapl_indexPathsFromIndexesWithSection(0))
                        }
                    }, completion: { finished in
                        if finished {
                            let changedIndexes = collectionChanges.changedIndexes
                            if (changedIndexes?.count ?? 0) != 0 {
                                collectionView.reloadItems(at: changedIndexes!.aapl_indexPathsFromIndexesWithSection(0))
                            }
                        }
                    })
                }
                self.mediaManager.resetCachedAssets()
            }
        }
    }
}
