//
//  File.swift
//  CTFit
//
//  Created by Mac on 2020/11/4.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import SnapKit



class SRLibraryViewCell: UICollectionViewCell {
    
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: .zero)
        backgroundColor = Colors.Base.background
        addSubviews()
    }
    
    override var isSelected: Bool {
        didSet { refreshSelection() }
    }
    
    override var isHighlighted: Bool {
        didSet { refreshSelection() }
    }
    
    private func refreshSelection() {
        let showOverlay = isSelected || isHighlighted
        selectionOverlay.alpha = showOverlay ? 0.6 : 0
    }
    
    ///: - View customer
    
    private func addSubviews() {
        let items = [imageView, durationLabel, multipleSelectionIndicator, selectionOverlay]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        imageView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
                
        durationLabel.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 5, right: 5))
        }
        
        multipleSelectionIndicator.snp.makeConstraints { (make) in
            make.top.equalToSuperview().offset(3)
            make.right.equalToSuperview().offset(-3)
        }
        
        selectionOverlay.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    lazy var representedAssetIdentifier: String = ""
    
    lazy var imageView: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    } ()
    
    lazy var durationLabel: UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.font = .systemFont(ofSize: 12)
        label.isHidden = true
        return label
    } ()
    
    private lazy var selectionOverlay: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.alpha = 0
        return view
    } ()
    
    lazy var multipleSelectionIndicator: SRMultipleSelectionIndicator = SRMultipleSelectionIndicator()
}


class SRMultipleSelectionIndicator: UIView {
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    init() {
        super.init(frame: .zero)
        addSubviews()
        set(number: nil)
    }
        
    ///: - View customer
    private func addSubviews() {
        let items = [circleView, numbLabel]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        circleView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
            make.width.height.equalTo(sz)
        }
        
        numbLabel.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    private let sz: CGFloat = 20
    
    private var selectionColor = Colors.blue
    
    private lazy var circleView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = sz / 2.0
        view.clipsToBounds = true
        return view
    } ()
    
    private lazy var numbLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.textColor = .white
        label.font = UIFont.systemFont(ofSize: 12, weight: .regular)
        return label
    } ()
    

    func set(number: Int?) {
        numbLabel.isHidden = (number == nil)
        if let number = number {
            circleView.backgroundColor = selectionColor
            circleView.layer.borderColor = UIColor.clear.cgColor
            circleView.layer.borderWidth = 0
            numbLabel.text = "\(number)"
        } else {
            circleView.backgroundColor = UIColor.white.withAlphaComponent(0.3)
            circleView.layer.borderColor = UIColor.white.cgColor
            circleView.layer.borderWidth = 1
            numbLabel.text = ""
        }
    }
}
