//
//  SRLimitedEditCell.swift
//  CTFitPro
//
//  Created by Mac on 2022/5/3.
//  Copyright © 2022 shirajo. All rights reserved.
//

import UIKit
import SnapKit

class SRLimitedEditCell: UICollectionViewCell {
    
    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: .zero)
        backgroundColor = Colors.Cell.background
        addSubviews()
    }
    
    ///: - View customer
    
    private func addSubviews() {
        let items = [imageView, text]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        imageView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
                
        text.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 6, right: 0))
        }
        
    }
        
    lazy var imageView: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    } ()
    
    lazy var text: UILabel = {
        let label = UILabel()
        label.textColor = .white
        label.font = .lightCustomFont(ofSize: 56)
        label.text = "+"
        label.textAlignment = .center
        label.contentMode = .center
        return label
    } ()
}
