//
//  SRLibraryCollectionPreviewController.swift
//  CTFit
//
//  Created by Mac on 2020/11/20.
//  Copyright © 2020 jpaxh. All rights reserved.
//

import UIKit
import Photos

class SRLibraryCollectionPreviewController: BaseViewController, CustomView {
    
    typealias ViewClass = SRLibraryCollectionPreview
    
    required init(_ manager: SRLibraryMediaManager, _ index: Int) {
        self.manager = manager
        self.index = index
        super.init()
        navigationItem.title = SRString.ImagePicker.preview.locastr
    }
    
    override func loadView() {
        super.loadView()
        view = ViewClass(manager, index)
    }
    
    override func initNavigationBar() {
        super.initNavigationBar()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = Colors.black_less
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        //customView.defaultSelectItem()

    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
    }
    
    ///:  - Field
    private var manager: SRLibraryMediaManager
    var index: Int
    
    @discardableResult
    static func enter(_ manager: SRLibraryMediaManager, _ index: Int) -> SRLibraryCollectionPreviewController? {
        guard let vc = Helper.currentVc else { return nil }
        let previewVc = SRLibraryCollectionPreviewController(manager, index)
        vc.navigationController?.pushViewController(previewVc, animated: true)
        return previewVc
    }
}


class SRLibraryCollectionPreview: UIView {
    
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    required init(_ manager: SRLibraryMediaManager, _ index: Int) {
        self.manager = manager
        self.index = index
        super.init(frame: .zero)
        setupSubviews()
        collectionView.reloadData()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
    }
    
    func defaultSelectItem() {
//        let indexPath = IndexPath(item: index, section: 0)
//        collectionView.selectItem(at: indexPath, animated: false, scrollPosition: .left)
//        collectionView.scrollToItem(at: indexPath, at: .centeredHorizontally, animated: false)
//        collectionView.contentOffset = CGPoint(x: (UIDevice.scrWidth + kMargin) * CGFloat(index), y: 0)
    }
    
    ///:  - Field
    private var manager: SRLibraryMediaManager
    var index: Int
    private let kMargin: CGFloat = 10
    ///: - View customer
    
    /// collection 布局
    lazy var flowLayout: UICollectionViewFlowLayout = {
        let layout = UICollectionViewFlowLayout()
        layout.scrollDirection = .horizontal
        layout.sectionInset = UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0)
        layout.minimumInteritemSpacing = 0
        layout.minimumLineSpacing = 0
        return layout
    }()
    
    /// collectionView
    lazy var collectionView: UICollectionView = {
        let collection = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collection.backgroundColor = .clear
        collection.dataSource = self
        collection.delegate = self
        collection.isPagingEnabled = true
        collection.scrollsToTop = false
        collection.showsHorizontalScrollIndicator = false
        collection.contentSize =  CGSize(width: (UIDevice.scrWidth + kMargin) * CGFloat(manager.fetchResultCount), height: 0);
        collection.contentOffset =  CGPoint(x: (UIDevice.scrWidth + kMargin) * CGFloat(index), y: 0);
        collection.register(SRLibraryCollectionPreviewCell.self, forCellWithReuseIdentifier: "SRLibraryCollectionPreviewCell")

        return collection
    }()
    
    /// bottomView
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = Colors.black
        return view
    }()
    
    private func setupSubviews() {
        let items = [collectionView, bottomView]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        
        collectionView.snp.makeConstraints { (make) in
            make.left.top.equalToSuperview()
            make.right.equalToSuperview().offset(kMargin)
        }
        
        bottomView.snp.makeConstraints { (make) in
            make.left.bottom.right.equalToSuperview()
            make.height.equalTo(UIDevice.bottomLayoutGuide)
            make.top.equalTo(collectionView.snp.bottom)
        }
    }
}



// MARK: - UICollectionViewDelegateFlowLayout

extension SRLibraryCollectionPreview: UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        var cSize = size
        cSize.height -= UIDevice.bottomLayoutGuide
        return cSize
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return kMargin
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return kMargin
    }
}

// MARK: - UICollectionViewDataSource
extension SRLibraryCollectionPreview: UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return manager.fetchResultCount
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell: SRLibraryCollectionPreviewCell = collectionView.dequeueReusableCell(withReuseIdentifier: "SRLibraryCollectionPreviewCell", for: indexPath) as! SRLibraryCollectionPreviewCell
        cell.load(manager, indexPath.row)
        UIView.performWithoutAnimation {
            cell.layoutIfNeeded()
        }
        return cell
    }
}

// MARK: - UICollectionViewDelegate
extension SRLibraryCollectionPreview: UICollectionViewDelegate {
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didEndDisplaying cell: UICollectionViewCell, forItemAt indexPath: IndexPath) {
        guard let theCell = cell as? SRLibraryCollectionPreviewCell else { return }
        theCell.fitImage()
    }
}


class SRLibraryCollectionPreviewCell: UICollectionViewCell {
    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: .zero)
        setupSubviews()
    }
    
    /// :- View customer
        
    private lazy var areaView: SRLibraryPreviewView = SRLibraryPreviewView()
    private func setupSubviews() {
        let items = [areaView]
        items.forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        areaView.snp.makeConstraints { (make) in
            make.edges.equalToSuperview().inset(UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 0))
        }
    }
    
    func load(_ manager: SRLibraryMediaManager, _ index: Int) {
        areaView.loadWith(manager, index)
    }
    
    func fitImage() {
        areaView.fitImage()
    }

}

    
